/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import rpl.shaded.com.fasterxml.jackson.databind.JsonNode;
import rpl.shaded.kafka.utils.Json$;
import rpl.shaded.kafka.utils.json.DecodeJson;
import rpl.shaded.kafka.utils.json.DecodeJson$;
import rpl.shaded.kafka.utils.json.DecodeJson$DecodeInt$;
import rpl.shaded.kafka.utils.json.DecodeJson$DecodeLong$;
import rpl.shaded.kafka.utils.json.DecodeJson$DecodeString$;
import rpl.shaded.kafka.utils.json.JsonObject;
import rpl.shaded.kafka.utils.json.JsonValue;
import rpl.shaded.org.apache.kafka.common.security.auth.KafkaPrincipal;
import rpl.shaded.org.apache.kafka.common.security.token.delegation.DelegationToken;
import rpl.shaded.org.apache.kafka.common.security.token.delegation.TokenInformation;
import rpl.shaded.org.apache.kafka.common.utils.Sanitizer;
import rpl.shaded.org.apache.kafka.common.utils.SecurityUtils;
import rpl.shaded.scala.$less$colon$less$;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Predef$;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.collection.Factory;
import rpl.shaded.scala.collection.Iterable;
import rpl.shaded.scala.collection.IterableFactory;
import rpl.shaded.scala.collection.IterableOps;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.immutable.List;
import rpl.shaded.scala.collection.immutable.Nil$;
import rpl.shaded.scala.collection.immutable.Seq;
import rpl.shaded.scala.collection.immutable.Seq$;
import rpl.shaded.scala.collection.mutable.Map;
import rpl.shaded.scala.collection.mutable.Map$;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.util.Either;

public final class DelegationTokenManager$ {
    public static final DelegationTokenManager$ MODULE$ = new DelegationTokenManager$();
    private static final String DefaultHmacAlgorithm = "HmacSHA512";
    private static final String OwnerKey = "owner";
    private static final String RenewersKey = "renewers";
    private static final String IssueTimestampKey = "issueTimestamp";
    private static final String MaxTimestampKey = "maxTimestamp";
    private static final String ExpiryTimestampKey = "expiryTimestamp";
    private static final String TokenIdKey = "tokenId";
    private static final String VersionKey = "version";
    private static final int CurrentVersion = 1;
    private static final int ErrorTimestamp = -1;

    public String DefaultHmacAlgorithm() {
        return DefaultHmacAlgorithm;
    }

    public String OwnerKey() {
        return OwnerKey;
    }

    public String RenewersKey() {
        return RenewersKey;
    }

    public String IssueTimestampKey() {
        return IssueTimestampKey;
    }

    public String MaxTimestampKey() {
        return MaxTimestampKey;
    }

    public String ExpiryTimestampKey() {
        return ExpiryTimestampKey;
    }

    public String TokenIdKey() {
        return TokenIdKey;
    }

    public String VersionKey() {
        return VersionKey;
    }

    public int CurrentVersion() {
        return CurrentVersion;
    }

    public int ErrorTimestamp() {
        return ErrorTimestamp;
    }

    public byte[] createHmac(String tokenId, String secretKey) {
        return this.createHmac(tokenId, this.createSecretKey(secretKey.getBytes(StandardCharsets.UTF_8)));
    }

    public SecretKey createSecretKey(byte[] keybytes) {
        return new SecretKeySpec(keybytes, this.DefaultHmacAlgorithm());
    }

    public String createBase64HMAC(String tokenId, SecretKey secretKey) {
        byte[] hmac = this.createHmac(tokenId, secretKey);
        return Base64.getEncoder().encodeToString(hmac);
    }

    public byte[] createHmac(String tokenId, SecretKey secretKey) {
        Mac mac = Mac.getInstance(this.DefaultHmacAlgorithm());
        try {
            mac.init(secretKey);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException("Invalid key to HMAC computation", ike);
        }
        return mac.doFinal(tokenId.getBytes(StandardCharsets.UTF_8));
    }

    public rpl.shaded.scala.collection.immutable.Map<String, Object> toJsonCompatibleMap(DelegationToken token) {
        TokenInformation tokenInfo = token.tokenInfo();
        Map tokenInfoMap = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        tokenInfoMap.update(this.VersionKey(), this.CurrentVersion());
        tokenInfoMap.update(this.OwnerKey(), Sanitizer.sanitize(tokenInfo.ownerAsString()));
        tokenInfoMap.update(this.RenewersKey(), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tokenInfo.renewersAsString()).asScala()).map((Function1<String, String> & Serializable)e -> Sanitizer.sanitize(e))).asJava());
        tokenInfoMap.update(this.IssueTimestampKey(), tokenInfo.issueTimestamp());
        tokenInfoMap.update(this.MaxTimestampKey(), tokenInfo.maxTimestamp());
        tokenInfoMap.update(this.ExpiryTimestampKey(), tokenInfo.expiryTimestamp());
        tokenInfoMap.update(this.TokenIdKey(), tokenInfo.tokenId());
        return tokenInfoMap.toMap($less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    public Option<TokenInformation> fromBytes(byte[] bytes) {
        Option option;
        boolean bl;
        if (bytes == null || (bl = bytes.length == 0)) {
            return None$.MODULE$;
        }
        Option<JsonValue> option2 = Json$.MODULE$.parseBytes(bytes);
        if (option2 instanceof Some) {
            void decodeSeq_factory;
            Factory factory;
            JsonObject mainJs = ((JsonValue)((Some)option2).value()).asJsonObject();
            Predef$.MODULE$.require(BoxesRunTime.unboxToInt(mainJs.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$)) == this.CurrentVersion());
            KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal(Sanitizer.desanitize(mainJs.apply(this.OwnerKey()).to(DecodeJson$DecodeString$.MODULE$)));
            Seq$ iterableFactory_this = Seq$.MODULE$;
            Factory factory2 = factory = IterableFactory.iterableFactory$(iterableFactory_this);
            Object var16_6 = null;
            factory = null;
            Factory factory3 = factory2;
            DecodeJson$DecodeString$ decodeSeq_decodeJson = DecodeJson$DecodeString$.MODULE$;
            Object var18_9 = null;
            factory3 = null;
            Seq renewers = (Seq)((IterableOps)((Seq)mainJs.apply(this.RenewersKey()).to(new DecodeJson<S>(decodeSeq_decodeJson, (Factory)decodeSeq_factory){
                private final DecodeJson decodeJson$2;
                private final Factory factory$1;

                public Object decode(JsonNode node) {
                    return DecodeJson.decode$(this, node);
                }

                public final Either<String, S> decodeEither(JsonNode node) {
                    return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeSeq$1(node, this.decodeJson$2, this.factory$1);
                }
                {
                    this.decodeJson$2 = decodeJson$2;
                    this.factory$1 = factory$1;
                }
            })).map((Function1<String, String> & Serializable)x$1 -> Sanitizer.desanitize(x$1))).map((Function1<String, KafkaPrincipal> & Serializable)x$2 -> SecurityUtils.parseKafkaPrincipal(x$2));
            long issueTimestamp = BoxesRunTime.unboxToLong(mainJs.apply(this.IssueTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            long expiryTimestamp = BoxesRunTime.unboxToLong(mainJs.apply(this.ExpiryTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            long maxTimestamp = BoxesRunTime.unboxToLong(mainJs.apply(this.MaxTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            String tokenId = mainJs.apply(this.TokenIdKey()).to(DecodeJson$DecodeString$.MODULE$);
            TokenInformation tokenInfo = new TokenInformation(tokenId, owner, JavaConverters$.MODULE$.seqAsJavaListConverter(renewers).asJava(), issueTimestamp, maxTimestamp, expiryTimestamp);
            option = new Some<TokenInformation>(tokenInfo);
        } else if (None$.MODULE$.equals(option2)) {
            option = None$.MODULE$;
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    public boolean filterToken(KafkaPrincipal requestedPrincipal, Option<List<KafkaPrincipal>> owners, TokenInformation token, Function1<String, Object> authorizeToken) {
        if (!owners.isEmpty()) {
            boolean bl;
            block6: {
                List list = owners.get();
                if (list == null) {
                    throw null;
                }
                List exists_these = list;
                while (!exists_these.isEmpty()) {
                    KafkaPrincipal kafkaPrincipal = (KafkaPrincipal)exists_these.head();
                    if (token.ownerOrRenewer(kafkaPrincipal)) {
                        bl = true;
                        break block6;
                    }
                    exists_these = (List)exists_these.tail();
                }
                bl = false;
            }
            Object var5_5 = null;
            if (!bl) {
                return false;
            }
        }
        if (token.ownerOrRenewer(requestedPrincipal)) {
            return true;
        }
        return BoxesRunTime.unboxToBoolean(authorizeToken.apply(token.tokenId()));
    }

    private DelegationTokenManager$() {
    }

    public static final /* synthetic */ Object $anonfun$filterToken$1$adapted(TokenInformation token$1, KafkaPrincipal owner) {
        return BoxesRunTime.boxToBoolean(token$1.ownerOrRenewer(owner));
    }
}

