/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import rpl.shaded.kafka.coordinator.transaction.Empty$;
import rpl.shaded.kafka.coordinator.transaction.TransactionLog$KeySchema$;
import rpl.shaded.kafka.coordinator.transaction.TransactionLog$ValueSchema$;
import rpl.shaded.kafka.coordinator.transaction.TransactionMetadata;
import rpl.shaded.kafka.coordinator.transaction.TransactionMetadata$;
import rpl.shaded.kafka.coordinator.transaction.TransactionState;
import rpl.shaded.kafka.coordinator.transaction.TxnKey;
import rpl.shaded.kafka.coordinator.transaction.TxnTransitMetadata;
import rpl.shaded.org.apache.kafka.common.KafkaException;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.org.apache.kafka.common.protocol.types.Schema;
import rpl.shaded.org.apache.kafka.common.protocol.types.Struct;
import rpl.shaded.org.apache.kafka.common.record.CompressionType;
import rpl.shaded.org.apache.kafka.common.record.Record;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Predef$;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.immutable.Iterable;
import rpl.shaded.scala.collection.mutable.ArraySeq;
import rpl.shaded.scala.collection.mutable.Set;
import rpl.shaded.scala.collection.mutable.Set$;
import rpl.shaded.scala.reflect.ClassTag$;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.Nothing$;

public final class TransactionLog$ {
    public static final TransactionLog$ MODULE$ = new TransactionLog$();
    private static final int DefaultNumPartitions = 50;
    private static final int DefaultSegmentBytes = 0x6400000;
    private static final short DefaultReplicationFactor = (short)3;
    private static final int DefaultMinInSyncReplicas = 2;
    private static final int DefaultLoadBufferSize = 0x500000;
    private static final CompressionType EnforcedCompressionType = CompressionType.NONE;
    private static final short EnforcedRequiredAcks = (short)-1;

    public int DefaultNumPartitions() {
        return DefaultNumPartitions;
    }

    public int DefaultSegmentBytes() {
        return DefaultSegmentBytes;
    }

    public short DefaultReplicationFactor() {
        return DefaultReplicationFactor;
    }

    public int DefaultMinInSyncReplicas() {
        return DefaultMinInSyncReplicas;
    }

    public int DefaultLoadBufferSize() {
        return DefaultLoadBufferSize;
    }

    public CompressionType EnforcedCompressionType() {
        return EnforcedCompressionType;
    }

    public short EnforcedRequiredAcks() {
        return EnforcedRequiredAcks;
    }

    public Schema kafka$coordinator$transaction$TransactionLog$$schemaForKey(int version) {
        Option<Schema> option = TransactionLog$KeySchema$.MODULE$.ofVersion(version);
        if (option == null) {
            throw null;
        }
        Option<Schema> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw TransactionLog$.$anonfun$schemaForKey$1(version);
        }
        return getOrElse_this.get();
    }

    public Schema kafka$coordinator$transaction$TransactionLog$$schemaForValue(int version) {
        Option<Schema> option = TransactionLog$ValueSchema$.MODULE$.ofVersion(version);
        if (option == null) {
            throw null;
        }
        Option<Schema> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw TransactionLog$.$anonfun$schemaForValue$1(version);
        }
        return getOrElse_this.get();
    }

    public byte[] keyToBytes(String transactionalId) {
        Struct key = new Struct(TransactionLog$KeySchema$.MODULE$.CURRENT());
        key.set(TransactionLog$KeySchema$.MODULE$.TXN_ID_FIELD(), (Object)transactionalId);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(TransactionLog$KeySchema$.MODULE$.CURRENT_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] valueToBytes(TxnTransitMetadata txnMetadata) {
        Struct value = new Struct(TransactionLog$ValueSchema$.MODULE$.Current());
        value.set(TransactionLog$ValueSchema$.MODULE$.ProducerIdField(), (Object)txnMetadata.producerId());
        value.set(TransactionLog$ValueSchema$.MODULE$.ProducerEpochField(), (Object)txnMetadata.producerEpoch());
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnTimeoutField(), (Object)txnMetadata.txnTimeoutMs());
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnStatusField(), (Object)txnMetadata.txnState().byte());
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnEntryTimestampField(), (Object)txnMetadata.txnLastUpdateTimestamp());
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnStartTimestampField(), (Object)txnMetadata.txnStartTimestamp());
        TransactionState transactionState = txnMetadata.txnState();
        Empty$ empty$ = Empty$.MODULE$;
        if (transactionState != null && transactionState.equals(empty$)) {
            if (txnMetadata.topicPartitions().nonEmpty()) {
                throw new IllegalStateException(new StringBuilder(72).append("Transaction is not expected to have any partitions since its state is ").append(txnMetadata.txnState()).append(": ").append(txnMetadata).toString());
            }
            value.set(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField(), null);
        } else {
            Iterable partitionArray = (Iterable)txnMetadata.topicPartitions().groupBy((Function1<TopicPartition, String> & Serializable)x$1 -> x$1.topic()).map((Function1<Tuple2, Struct> & Serializable)x0$1 -> {
                void var4_4;
                if (x0$1 == null) {
                    throw new MatchError((Object)null);
                }
                String topic = (String)x0$1._1();
                rpl.shaded.scala.collection.immutable.Set partitions = (rpl.shaded.scala.collection.immutable.Set)x0$1._2();
                Struct topicPartitionsStruct = value.instance(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField());
                Integer[] partitionIds = (Integer[])((IterableOnceOps)partitions.map((Function1<TopicPartition, Integer> & Serializable)topicPartition -> topicPartition.partition())).toArray(ClassTag$.MODULE$.apply(Integer.class));
                topicPartitionsStruct.set(TransactionLog$ValueSchema$.MODULE$.PartitionsTopicField(), (Object)topic);
                topicPartitionsStruct.set(TransactionLog$ValueSchema$.MODULE$.PartitionIdsField(), (Object)partitionIds);
                return var4_4;
            });
            value.set(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField(), partitionArray.toArray(ClassTag$.MODULE$.apply(Struct.class)));
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value.sizeOf());
        byteBuffer.putShort(TransactionLog$ValueSchema$.MODULE$.CurrentVersion());
        value.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public TxnKey readTxnRecordKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        Struct key = this.kafka$coordinator$transaction$TransactionLog$$schemaForKey(version).read(buffer);
        if (version == TransactionLog$KeySchema$.MODULE$.CURRENT_VERSION()) {
            String transactionalId = key.getString(TransactionLog$KeySchema$.MODULE$.TXN_ID_FIELD());
            return new TxnKey(version, transactionalId);
        }
        throw new IllegalStateException(new StringBuilder(49).append("Unknown version ").append(version).append(" from the transaction log message").toString());
    }

    public Option<TransactionMetadata> readTxnRecordValue(String transactionalId, ByteBuffer buffer) {
        if (buffer == null) {
            return None$.MODULE$;
        }
        short version = buffer.getShort();
        Struct value = this.kafka$coordinator$transaction$TransactionLog$$schemaForValue(version).read(buffer);
        if (version == TransactionLog$ValueSchema$.MODULE$.CurrentVersion()) {
            Long producerId = value.getLong(TransactionLog$ValueSchema$.MODULE$.ProducerIdField());
            Short epoch = value.getShort(TransactionLog$ValueSchema$.MODULE$.ProducerEpochField());
            Integer timeout = value.getInt(TransactionLog$ValueSchema$.MODULE$.TxnTimeoutField());
            Byte stateByte = value.getByte(TransactionLog$ValueSchema$.MODULE$.TxnStatusField());
            TransactionState state = TransactionMetadata$.MODULE$.byteToState(BoxesRunTime.unboxToByte(stateByte));
            Long entryTimestamp = value.getLong(TransactionLog$ValueSchema$.MODULE$.TxnEntryTimestampField());
            Long startTimestamp = value.getLong(TransactionLog$ValueSchema$.MODULE$.TxnStartTimestampField());
            TransactionMetadata transactionMetadata = new TransactionMetadata(transactionalId, BoxesRunTime.unboxToLong(producerId), -1L, BoxesRunTime.unboxToShort(epoch), -1, BoxesRunTime.unboxToInt(timeout), state, (Set)Set$.MODULE$.empty(), BoxesRunTime.unboxToLong(startTimestamp), BoxesRunTime.unboxToLong(entryTimestamp));
            if (!state.equals(Empty$.MODULE$)) {
                for (Object object : value.getArray(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField())) {
                    TransactionLog$.$anonfun$readTxnRecordValue$1(transactionMetadata, object);
                }
            }
            return new Some<TransactionMetadata>(transactionMetadata);
        }
        throw new IllegalStateException(new StringBuilder(55).append("Unknown version ").append(version).append(" from the transaction log message value").toString());
    }

    public Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        String string;
        TxnKey txnKey = this.readTxnRecordKey(record.key());
        String keyString = new StringBuilder(38).append("transaction_metadata::transactionalId=").append(txnKey.transactionalId()).toString();
        Option<TransactionMetadata> option = this.readTxnRecordValue(txnKey.transactionalId(), record.value());
        if (None$.MODULE$.equals(option)) {
            string = "<DELETE>";
        } else if (option instanceof Some) {
            TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
            string = new StringBuilder(0).append(new StringBuilder(12).append("producerId:").append(txnMetadata.producerId()).append(",").toString()).append(new StringBuilder(15).append("producerEpoch:").append(txnMetadata.producerEpoch()).append(",").toString()).append(new StringBuilder(7).append("state=").append(txnMetadata.state()).append(",").toString()).append(new StringBuilder(12).append("partitions=").append(txnMetadata.topicPartitions().mkString("[", ",", "]")).append(",").toString()).append(new StringBuilder(24).append("txnLastUpdateTimestamp=").append(txnMetadata.txnLastUpdateTimestamp()).append(",").toString()).append(new StringBuilder(13).append("txnTimeoutMs=").append(txnMetadata.txnTimeoutMs()).toString()).toString();
        } else {
            throw new MatchError(option);
        }
        return new Tuple2<Option<String>, Option<String>>(new Some<String>(keyString), new Some<String>(string));
    }

    public static final /* synthetic */ Nothing$ $anonfun$schemaForKey$1(int version$1) {
        throw new KafkaException(new StringBuilder(51).append("Unknown transaction log message key schema version ").append(version$1).toString());
    }

    public static final /* synthetic */ Nothing$ $anonfun$schemaForValue$1(int version$2) {
        throw new KafkaException(new StringBuilder(53).append("Unknown transaction log message value schema version ").append(version$2).toString());
    }

    public static final /* synthetic */ TopicPartition $anonfun$readTxnRecordValue$2(String topic$1, Object partitionIdObj) {
        Integer partitionId = (Integer)partitionIdObj;
        return new TopicPartition(topic$1, BoxesRunTime.unboxToInt(partitionId));
    }

    public static final /* synthetic */ void $anonfun$readTxnRecordValue$1(TransactionMetadata transactionMetadata$1, Object memberMetadataObj) {
        Object var6_6;
        Struct memberMetadata = (Struct)memberMetadataObj;
        String topic = memberMetadata.getString(TransactionLog$ValueSchema$.MODULE$.PartitionsTopicField());
        Object[] partitionIdArray = memberMetadata.getArray(TransactionLog$ValueSchema$.MODULE$.PartitionIdsField());
        int n = partitionIdArray.length;
        TopicPartition[] map$extension_ys = new TopicPartition[n];
        if (n > 0) {
            for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                TopicPartition array_update_value;
                Object object = partitionIdArray[map$extension_i];
                map$extension_ys[map$extension_i] = array_update_value = TransactionLog$.$anonfun$readTxnRecordValue$2(topic, object);
                Object var10_9 = null;
            }
        }
        void v0 = var6_6;
        var6_6 = null;
        void topicPartitions = v0;
        ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray((T[])topicPartitions);
        if (ofRef2 == null) {
            throw null;
        }
        transactionMetadata$1.addPartitions(IterableOnceOps.toSet$(ofRef2));
    }

    private TransactionLog$() {
    }

    public static final /* synthetic */ Object $anonfun$readTxnRecordValue$1$adapted(TransactionMetadata transactionMetadata$1, Object memberMetadataObj) {
        TransactionLog$.$anonfun$readTxnRecordValue$1(transactionMetadata$1, memberMetadataObj);
        return BoxedUnit.UNIT;
    }
}

