/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.coordinator.group;

import java.nio.ByteBuffer;
import java.util.Optional;
import rpl.shaded.kafka.api.ApiVersion;
import rpl.shaded.kafka.api.KAFKA_0_10_1_IV0$;
import rpl.shaded.kafka.api.KAFKA_2_1_IV0$;
import rpl.shaded.kafka.api.KAFKA_2_1_IV1$;
import rpl.shaded.kafka.api.KAFKA_2_3_IV0$;
import rpl.shaded.kafka.common.OffsetAndMetadata;
import rpl.shaded.kafka.common.OffsetAndMetadata$;
import rpl.shaded.kafka.coordinator.group.BaseKey;
import rpl.shaded.kafka.coordinator.group.Empty$;
import rpl.shaded.kafka.coordinator.group.GroupMetadata;
import rpl.shaded.kafka.coordinator.group.GroupMetadata$;
import rpl.shaded.kafka.coordinator.group.GroupMetadataKey;
import rpl.shaded.kafka.coordinator.group.GroupState;
import rpl.shaded.kafka.coordinator.group.GroupTopicPartition;
import rpl.shaded.kafka.coordinator.group.MemberMetadata;
import rpl.shaded.kafka.coordinator.group.OffsetKey;
import rpl.shaded.kafka.coordinator.group.Stable$;
import rpl.shaded.kafka.utils.Json$;
import rpl.shaded.org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import rpl.shaded.org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import rpl.shaded.org.apache.kafka.common.KafkaException;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import rpl.shaded.org.apache.kafka.common.protocol.types.BoundField;
import rpl.shaded.org.apache.kafka.common.protocol.types.Field;
import rpl.shaded.org.apache.kafka.common.protocol.types.Schema;
import rpl.shaded.org.apache.kafka.common.protocol.types.Struct;
import rpl.shaded.org.apache.kafka.common.protocol.types.Type;
import rpl.shaded.org.apache.kafka.common.record.Record;
import rpl.shaded.org.apache.kafka.common.utils.Time;
import rpl.shaded.org.apache.kafka.common.utils.Utils;
import rpl.shaded.scala.$eq$colon$eq;
import rpl.shaded.scala.$less$colon$less$;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Option$;
import rpl.shaded.scala.Predef$;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.Map;
import rpl.shaded.scala.collection.Map$;
import rpl.shaded.scala.collection.StringOps$;
import rpl.shaded.scala.collection.immutable.$colon$colon;
import rpl.shaded.scala.collection.immutable.List;
import rpl.shaded.scala.collection.immutable.Nil$;
import rpl.shaded.scala.package$;
import rpl.shaded.scala.reflect.ClassTag$;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.Nothing$;
import rpl.shaded.scala.runtime.ScalaRunTime$;
import rpl.shaded.scala.runtime.Statics;

public final class GroupMetadataManager$ {
    public static final GroupMetadataManager$ MODULE$;
    private static final short CURRENT_OFFSET_KEY_SCHEMA_VERSION;
    private static final short CURRENT_GROUP_KEY_SCHEMA_VERSION;
    private static final Schema OFFSET_COMMIT_KEY_SCHEMA;
    private static final BoundField OFFSET_KEY_GROUP_FIELD;
    private static final BoundField OFFSET_KEY_TOPIC_FIELD;
    private static final BoundField OFFSET_KEY_PARTITION_FIELD;
    private static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V0;
    private static final BoundField OFFSET_VALUE_OFFSET_FIELD_V0;
    private static final BoundField OFFSET_VALUE_METADATA_FIELD_V0;
    private static final BoundField OFFSET_VALUE_TIMESTAMP_FIELD_V0;
    private static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V1;
    private static final BoundField OFFSET_VALUE_OFFSET_FIELD_V1;
    private static final BoundField OFFSET_VALUE_METADATA_FIELD_V1;
    private static final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    private static final BoundField OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    private static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V2;
    private static final BoundField OFFSET_VALUE_OFFSET_FIELD_V2;
    private static final BoundField OFFSET_VALUE_METADATA_FIELD_V2;
    private static final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2;
    private static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V3;
    private static final BoundField OFFSET_VALUE_OFFSET_FIELD_V3;
    private static final BoundField OFFSET_VALUE_LEADER_EPOCH_FIELD_V3;
    private static final BoundField OFFSET_VALUE_METADATA_FIELD_V3;
    private static final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3;
    private static final Schema GROUP_METADATA_KEY_SCHEMA;
    private static final BoundField GROUP_KEY_GROUP_FIELD;
    private static final String MEMBER_ID_KEY;
    private static final String GROUP_INSTANCE_ID_KEY;
    private static final String CLIENT_ID_KEY;
    private static final String CLIENT_HOST_KEY;
    private static final String REBALANCE_TIMEOUT_KEY;
    private static final String SESSION_TIMEOUT_KEY;
    private static final String SUBSCRIPTION_KEY;
    private static final String ASSIGNMENT_KEY;
    private static final Schema MEMBER_METADATA_V0;
    private static final Schema MEMBER_METADATA_V1;
    private static final Schema MEMBER_METADATA_V2;
    private static final Schema MEMBER_METADATA_V3;
    private static final String PROTOCOL_TYPE_KEY;
    private static final String GENERATION_KEY;
    private static final String PROTOCOL_KEY;
    private static final String LEADER_KEY;
    private static final String CURRENT_STATE_TIMESTAMP_KEY;
    private static final String MEMBERS_KEY;
    private static final Schema GROUP_METADATA_VALUE_SCHEMA_V0;
    private static final Schema GROUP_METADATA_VALUE_SCHEMA_V1;
    private static final Schema GROUP_METADATA_VALUE_SCHEMA_V2;
    private static final Schema GROUP_METADATA_VALUE_SCHEMA_V3;
    private static final Map<Object, Schema> MESSAGE_TYPE_SCHEMAS;
    private static final Map<Object, Schema> OFFSET_VALUE_SCHEMAS;
    private static final Map<Object, Schema> GROUP_VALUE_SCHEMAS;
    private static final Schema CURRENT_OFFSET_KEY_SCHEMA;
    private static final Schema CURRENT_GROUP_KEY_SCHEMA;

    /*
     * WARNING - void declaration
     */
    static {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_y9;
        MODULE$ = new GroupMetadataManager$();
        CURRENT_OFFSET_KEY_SCHEMA_VERSION = (short)1;
        CURRENT_GROUP_KEY_SCHEMA_VERSION = (short)2;
        OFFSET_COMMIT_KEY_SCHEMA = new Schema(new Field("group", Type.STRING), new Field("topic", Type.STRING), new Field("partition", Type.INT32));
        OFFSET_KEY_GROUP_FIELD = MODULE$.OFFSET_COMMIT_KEY_SCHEMA().get("group");
        OFFSET_KEY_TOPIC_FIELD = MODULE$.OFFSET_COMMIT_KEY_SCHEMA().get("topic");
        OFFSET_KEY_PARTITION_FIELD = MODULE$.OFFSET_COMMIT_KEY_SCHEMA().get("partition");
        OFFSET_COMMIT_VALUE_SCHEMA_V0 = new Schema(new Field("offset", Type.INT64), new Field("metadata", Type.STRING, "Associated metadata.", ""), new Field("timestamp", Type.INT64));
        OFFSET_VALUE_OFFSET_FIELD_V0 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("offset");
        OFFSET_VALUE_METADATA_FIELD_V0 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("metadata");
        OFFSET_VALUE_TIMESTAMP_FIELD_V0 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("timestamp");
        OFFSET_COMMIT_VALUE_SCHEMA_V1 = new Schema(new Field("offset", Type.INT64), new Field("metadata", Type.STRING, "Associated metadata.", ""), new Field("commit_timestamp", Type.INT64), new Field("expire_timestamp", Type.INT64));
        OFFSET_VALUE_OFFSET_FIELD_V1 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("offset");
        OFFSET_VALUE_METADATA_FIELD_V1 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("metadata");
        OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("commit_timestamp");
        OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("expire_timestamp");
        OFFSET_COMMIT_VALUE_SCHEMA_V2 = new Schema(new Field("offset", Type.INT64), new Field("metadata", Type.STRING, "Associated metadata.", ""), new Field("commit_timestamp", Type.INT64));
        OFFSET_VALUE_OFFSET_FIELD_V2 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("offset");
        OFFSET_VALUE_METADATA_FIELD_V2 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("metadata");
        OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("commit_timestamp");
        OFFSET_COMMIT_VALUE_SCHEMA_V3 = new Schema(new Field("offset", Type.INT64), new Field("leader_epoch", Type.INT32), new Field("metadata", Type.STRING, "Associated metadata.", ""), new Field("commit_timestamp", Type.INT64));
        OFFSET_VALUE_OFFSET_FIELD_V3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("offset");
        OFFSET_VALUE_LEADER_EPOCH_FIELD_V3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("leader_epoch");
        OFFSET_VALUE_METADATA_FIELD_V3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("metadata");
        OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("commit_timestamp");
        GROUP_METADATA_KEY_SCHEMA = new Schema(new Field("group", Type.STRING));
        GROUP_KEY_GROUP_FIELD = MODULE$.GROUP_METADATA_KEY_SCHEMA().get("group");
        MEMBER_ID_KEY = "member_id";
        GROUP_INSTANCE_ID_KEY = "group_instance_id";
        CLIENT_ID_KEY = "client_id";
        CLIENT_HOST_KEY = "client_host";
        REBALANCE_TIMEOUT_KEY = "rebalance_timeout";
        SESSION_TIMEOUT_KEY = "session_timeout";
        SUBSCRIPTION_KEY = "subscription";
        ASSIGNMENT_KEY = "assignment";
        MEMBER_METADATA_V0 = new Schema(new Field(MODULE$.MEMBER_ID_KEY(), Type.STRING), new Field(MODULE$.CLIENT_ID_KEY(), Type.STRING), new Field(MODULE$.CLIENT_HOST_KEY(), Type.STRING), new Field(MODULE$.SESSION_TIMEOUT_KEY(), Type.INT32), new Field(MODULE$.SUBSCRIPTION_KEY(), Type.BYTES), new Field(MODULE$.ASSIGNMENT_KEY(), Type.BYTES));
        MEMBER_METADATA_V1 = new Schema(new Field(MODULE$.MEMBER_ID_KEY(), Type.STRING), new Field(MODULE$.CLIENT_ID_KEY(), Type.STRING), new Field(MODULE$.CLIENT_HOST_KEY(), Type.STRING), new Field(MODULE$.REBALANCE_TIMEOUT_KEY(), Type.INT32), new Field(MODULE$.SESSION_TIMEOUT_KEY(), Type.INT32), new Field(MODULE$.SUBSCRIPTION_KEY(), Type.BYTES), new Field(MODULE$.ASSIGNMENT_KEY(), Type.BYTES));
        MEMBER_METADATA_V2 = MODULE$.MEMBER_METADATA_V1();
        MEMBER_METADATA_V3 = new Schema(new Field(MODULE$.MEMBER_ID_KEY(), Type.STRING), new Field(MODULE$.GROUP_INSTANCE_ID_KEY(), Type.NULLABLE_STRING), new Field(MODULE$.CLIENT_ID_KEY(), Type.STRING), new Field(MODULE$.CLIENT_HOST_KEY(), Type.STRING), new Field(MODULE$.REBALANCE_TIMEOUT_KEY(), Type.INT32), new Field(MODULE$.SESSION_TIMEOUT_KEY(), Type.INT32), new Field(MODULE$.SUBSCRIPTION_KEY(), Type.BYTES), new Field(MODULE$.ASSIGNMENT_KEY(), Type.BYTES));
        PROTOCOL_TYPE_KEY = "protocol_type";
        GENERATION_KEY = "generation";
        PROTOCOL_KEY = "protocol";
        LEADER_KEY = "leader";
        CURRENT_STATE_TIMESTAMP_KEY = "current_state_timestamp";
        MEMBERS_KEY = "members";
        GROUP_METADATA_VALUE_SCHEMA_V0 = new Schema(new Field(MODULE$.PROTOCOL_TYPE_KEY(), Type.STRING), new Field(MODULE$.GENERATION_KEY(), Type.INT32), new Field(MODULE$.PROTOCOL_KEY(), Type.NULLABLE_STRING), new Field(MODULE$.LEADER_KEY(), Type.NULLABLE_STRING), new Field(MODULE$.MEMBERS_KEY(), new ArrayOf(MODULE$.MEMBER_METADATA_V0())));
        GROUP_METADATA_VALUE_SCHEMA_V1 = new Schema(new Field(MODULE$.PROTOCOL_TYPE_KEY(), Type.STRING), new Field(MODULE$.GENERATION_KEY(), Type.INT32), new Field(MODULE$.PROTOCOL_KEY(), Type.NULLABLE_STRING), new Field(MODULE$.LEADER_KEY(), Type.NULLABLE_STRING), new Field(MODULE$.MEMBERS_KEY(), new ArrayOf(MODULE$.MEMBER_METADATA_V1())));
        GROUP_METADATA_VALUE_SCHEMA_V2 = new Schema(new Field(MODULE$.PROTOCOL_TYPE_KEY(), Type.STRING), new Field(MODULE$.GENERATION_KEY(), Type.INT32), new Field(MODULE$.PROTOCOL_KEY(), Type.NULLABLE_STRING), new Field(MODULE$.LEADER_KEY(), Type.NULLABLE_STRING), new Field(MODULE$.CURRENT_STATE_TIMESTAMP_KEY(), Type.INT64), new Field(MODULE$.MEMBERS_KEY(), new ArrayOf(MODULE$.MEMBER_METADATA_V2())));
        GROUP_METADATA_VALUE_SCHEMA_V3 = new Schema(new Field(MODULE$.PROTOCOL_TYPE_KEY(), Type.STRING), new Field(MODULE$.GENERATION_KEY(), Type.INT32), new Field(MODULE$.PROTOCOL_KEY(), Type.NULLABLE_STRING), new Field(MODULE$.LEADER_KEY(), Type.NULLABLE_STRING), new Field(MODULE$.CURRENT_STATE_TIMESTAMP_KEY(), Type.INT64), new Field(MODULE$.MEMBERS_KEY(), new ArrayOf(MODULE$.MEMBER_METADATA_V3())));
        Tuple2[] tuple2Array = new Tuple2[3];
        Schema $minus$greater$extension_y10 = MODULE$.OFFSET_COMMIT_KEY_SCHEMA();
        Integer $minus$greater$extension_$this = Predef$.MODULE$.ArrowAssoc(0);
        Object var0_1 = null;
        Object var1 = null;
        tuple2Array[0] = new Tuple2<Integer, Schema>($minus$greater$extension_$this, $minus$greater$extension_y10);
        Schema $minus$greater$extension_y11 = MODULE$.OFFSET_COMMIT_KEY_SCHEMA();
        Integer $minus$greater$extension_$this2 = Predef$.MODULE$.ArrowAssoc(1);
        Object var2_3 = null;
        Object var3_2 = null;
        tuple2Array[1] = new Tuple2<Integer, Schema>($minus$greater$extension_$this2, $minus$greater$extension_y11);
        Schema schema = MODULE$.GROUP_METADATA_KEY_SCHEMA();
        Integer $minus$greater$extension_$this3 = Predef$.MODULE$.ArrowAssoc(2);
        Object var4_5 = null;
        schema = null;
        tuple2Array[2] = new Tuple2<Integer, void>($minus$greater$extension_$this3, $minus$greater$extension_y9);
        MESSAGE_TYPE_SCHEMAS = (Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
        Tuple2[] tuple2Array2 = new Tuple2[4];
        Schema schema2 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V0();
        Integer $minus$greater$extension_$this4 = Predef$.MODULE$.ArrowAssoc(0);
        Object var6_7 = null;
        schema2 = null;
        tuple2Array2[0] = new Tuple2<Integer, void>($minus$greater$extension_$this4, $minus$greater$extension_y8);
        Schema schema3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1();
        Integer $minus$greater$extension_$this5 = Predef$.MODULE$.ArrowAssoc(1);
        Object var8_9 = null;
        schema3 = null;
        tuple2Array2[1] = new Tuple2<Integer, void>($minus$greater$extension_$this5, $minus$greater$extension_y7);
        Schema schema4 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V2();
        Integer $minus$greater$extension_$this6 = Predef$.MODULE$.ArrowAssoc(2);
        Object var10_11 = null;
        schema4 = null;
        tuple2Array2[2] = new Tuple2<Integer, void>($minus$greater$extension_$this6, $minus$greater$extension_y6);
        Schema schema5 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3();
        Integer $minus$greater$extension_$this7 = Predef$.MODULE$.ArrowAssoc(3);
        Object var12_13 = null;
        schema5 = null;
        tuple2Array2[3] = new Tuple2<Integer, void>($minus$greater$extension_$this7, $minus$greater$extension_y5);
        OFFSET_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array2));
        Tuple2[] tuple2Array3 = new Tuple2[4];
        Schema schema6 = MODULE$.GROUP_METADATA_VALUE_SCHEMA_V0();
        Integer $minus$greater$extension_$this8 = Predef$.MODULE$.ArrowAssoc(0);
        Object var14_15 = null;
        schema6 = null;
        tuple2Array3[0] = new Tuple2<Integer, void>($minus$greater$extension_$this8, $minus$greater$extension_y4);
        Schema schema7 = MODULE$.GROUP_METADATA_VALUE_SCHEMA_V1();
        Integer $minus$greater$extension_$this9 = Predef$.MODULE$.ArrowAssoc(1);
        Object var16_17 = null;
        schema7 = null;
        tuple2Array3[1] = new Tuple2<Integer, void>($minus$greater$extension_$this9, $minus$greater$extension_y3);
        Schema schema8 = MODULE$.GROUP_METADATA_VALUE_SCHEMA_V2();
        Integer $minus$greater$extension_$this10 = Predef$.MODULE$.ArrowAssoc(2);
        Object var18_19 = null;
        schema8 = null;
        tuple2Array3[2] = new Tuple2<Integer, void>($minus$greater$extension_$this10, $minus$greater$extension_y2);
        Schema schema9 = MODULE$.GROUP_METADATA_VALUE_SCHEMA_V3();
        Integer $minus$greater$extension_$this11 = Predef$.MODULE$.ArrowAssoc(3);
        Object var20_21 = null;
        schema9 = null;
        tuple2Array3[3] = new Tuple2<Integer, void>($minus$greater$extension_$this11, $minus$greater$extension_y);
        GROUP_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array3));
        CURRENT_OFFSET_KEY_SCHEMA = MODULE$.schemaForKey(MODULE$.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
        CURRENT_GROUP_KEY_SCHEMA = MODULE$.schemaForKey(MODULE$.CURRENT_GROUP_KEY_SCHEMA_VERSION());
    }

    private short CURRENT_OFFSET_KEY_SCHEMA_VERSION() {
        return CURRENT_OFFSET_KEY_SCHEMA_VERSION;
    }

    private short CURRENT_GROUP_KEY_SCHEMA_VERSION() {
        return CURRENT_GROUP_KEY_SCHEMA_VERSION;
    }

    private Schema OFFSET_COMMIT_KEY_SCHEMA() {
        return OFFSET_COMMIT_KEY_SCHEMA;
    }

    private BoundField OFFSET_KEY_GROUP_FIELD() {
        return OFFSET_KEY_GROUP_FIELD;
    }

    private BoundField OFFSET_KEY_TOPIC_FIELD() {
        return OFFSET_KEY_TOPIC_FIELD;
    }

    private BoundField OFFSET_KEY_PARTITION_FIELD() {
        return OFFSET_KEY_PARTITION_FIELD;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V0() {
        return OFFSET_COMMIT_VALUE_SCHEMA_V0;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V0() {
        return OFFSET_VALUE_OFFSET_FIELD_V0;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V0() {
        return OFFSET_VALUE_METADATA_FIELD_V0;
    }

    private BoundField OFFSET_VALUE_TIMESTAMP_FIELD_V0() {
        return OFFSET_VALUE_TIMESTAMP_FIELD_V0;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V1() {
        return OFFSET_COMMIT_VALUE_SCHEMA_V1;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V1() {
        return OFFSET_VALUE_OFFSET_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V1() {
        return OFFSET_VALUE_METADATA_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1() {
        return OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1() {
        return OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V2() {
        return OFFSET_COMMIT_VALUE_SCHEMA_V2;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V2() {
        return OFFSET_VALUE_OFFSET_FIELD_V2;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V2() {
        return OFFSET_VALUE_METADATA_FIELD_V2;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2() {
        return OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V3() {
        return OFFSET_COMMIT_VALUE_SCHEMA_V3;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V3() {
        return OFFSET_VALUE_OFFSET_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_LEADER_EPOCH_FIELD_V3() {
        return OFFSET_VALUE_LEADER_EPOCH_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V3() {
        return OFFSET_VALUE_METADATA_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3() {
        return OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3;
    }

    private Schema GROUP_METADATA_KEY_SCHEMA() {
        return GROUP_METADATA_KEY_SCHEMA;
    }

    private BoundField GROUP_KEY_GROUP_FIELD() {
        return GROUP_KEY_GROUP_FIELD;
    }

    private String MEMBER_ID_KEY() {
        return MEMBER_ID_KEY;
    }

    private String GROUP_INSTANCE_ID_KEY() {
        return GROUP_INSTANCE_ID_KEY;
    }

    private String CLIENT_ID_KEY() {
        return CLIENT_ID_KEY;
    }

    private String CLIENT_HOST_KEY() {
        return CLIENT_HOST_KEY;
    }

    private String REBALANCE_TIMEOUT_KEY() {
        return REBALANCE_TIMEOUT_KEY;
    }

    private String SESSION_TIMEOUT_KEY() {
        return SESSION_TIMEOUT_KEY;
    }

    private String SUBSCRIPTION_KEY() {
        return SUBSCRIPTION_KEY;
    }

    private String ASSIGNMENT_KEY() {
        return ASSIGNMENT_KEY;
    }

    private Schema MEMBER_METADATA_V0() {
        return MEMBER_METADATA_V0;
    }

    private Schema MEMBER_METADATA_V1() {
        return MEMBER_METADATA_V1;
    }

    private Schema MEMBER_METADATA_V2() {
        return MEMBER_METADATA_V2;
    }

    private Schema MEMBER_METADATA_V3() {
        return MEMBER_METADATA_V3;
    }

    private String PROTOCOL_TYPE_KEY() {
        return PROTOCOL_TYPE_KEY;
    }

    private String GENERATION_KEY() {
        return GENERATION_KEY;
    }

    private String PROTOCOL_KEY() {
        return PROTOCOL_KEY;
    }

    private String LEADER_KEY() {
        return LEADER_KEY;
    }

    private String CURRENT_STATE_TIMESTAMP_KEY() {
        return CURRENT_STATE_TIMESTAMP_KEY;
    }

    private String MEMBERS_KEY() {
        return MEMBERS_KEY;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V0() {
        return GROUP_METADATA_VALUE_SCHEMA_V0;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V1() {
        return GROUP_METADATA_VALUE_SCHEMA_V1;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V2() {
        return GROUP_METADATA_VALUE_SCHEMA_V2;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V3() {
        return GROUP_METADATA_VALUE_SCHEMA_V3;
    }

    private Map<Object, Schema> MESSAGE_TYPE_SCHEMAS() {
        return MESSAGE_TYPE_SCHEMAS;
    }

    private Map<Object, Schema> OFFSET_VALUE_SCHEMAS() {
        return OFFSET_VALUE_SCHEMAS;
    }

    private Map<Object, Schema> GROUP_VALUE_SCHEMAS() {
        return GROUP_VALUE_SCHEMAS;
    }

    private Schema CURRENT_OFFSET_KEY_SCHEMA() {
        return CURRENT_OFFSET_KEY_SCHEMA;
    }

    private Schema CURRENT_GROUP_KEY_SCHEMA() {
        return CURRENT_GROUP_KEY_SCHEMA;
    }

    /*
     * WARNING - void declaration
     */
    private Schema schemaForKey(int version) {
        void var3_3;
        Option schemaOpt = this.MESSAGE_TYPE_SCHEMAS().get(version);
        if (!(schemaOpt instanceof Some)) {
            throw new KafkaException(new StringBuilder(35).append("Unknown message key schema version ").append(version).toString());
        }
        Schema schema = (Schema)((Some)schemaOpt).value();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Schema schemaForOffsetValue(int version) {
        void var3_3;
        Option schemaOpt = this.OFFSET_VALUE_SCHEMAS().get(version);
        if (!(schemaOpt instanceof Some)) {
            throw new KafkaException(new StringBuilder(30).append("Unknown offset schema version ").append(version).toString());
        }
        Schema schema = (Schema)((Some)schemaOpt).value();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Schema schemaForGroupValue(int version) {
        void var3_3;
        Option schemaOpt = this.GROUP_VALUE_SCHEMAS().get(version);
        if (!(schemaOpt instanceof Some)) {
            throw new KafkaException(new StringBuilder(31).append("Unknown group metadata version ").append(version).toString());
        }
        Schema schema = (Schema)((Some)schemaOpt).value();
        return var3_3;
    }

    public byte[] offsetCommitKey(String group, TopicPartition topicPartition) {
        Struct key = new Struct(this.CURRENT_OFFSET_KEY_SCHEMA());
        key.set(this.OFFSET_KEY_GROUP_FIELD(), (Object)group);
        key.set(this.OFFSET_KEY_TOPIC_FIELD(), (Object)topicPartition.topic());
        key.set(this.OFFSET_KEY_PARTITION_FIELD(), (Object)topicPartition.partition());
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] groupMetadataKey(String group) {
        Struct key = new Struct(this.CURRENT_GROUP_KEY_SCHEMA());
        key.set(this.GROUP_KEY_GROUP_FIELD(), (Object)group);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_GROUP_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    /*
     * Unable to fully structure code
     */
    public byte[] offsetCommitValue(OffsetAndMetadata offsetAndMetadata, ApiVersion apiVersion) {
        if (apiVersion.$less(KAFKA_2_1_IV0$.MODULE$)) ** GOTO lbl-1000
        v0 = offsetAndMetadata.expireTimestamp();
        if (v0 == null) {
            throw null;
        }
        if (v0.isDefined()) lbl-1000:
        // 2 sources

        {
            value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V1());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V1(), (Object)offsetAndMetadata.offset());
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V1(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1(), (Object)offsetAndMetadata.commitTimestamp());
            v1 = this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1();
            v2 = offsetAndMetadata.expireTimestamp();
            if (v2 == null) {
                throw null;
            }
            getOrElse_this = v2;
            if (getOrElse_this.isEmpty()) {
                v3 = var10_5 = Long.valueOf(-1L);
                var10_5 = null;
                var9_6 = v3;
            } else {
                var9_6 = getOrElse_this.get();
            }
            v4 = var9_6;
            var8_4 = null;
            var9_6 = null;
            value.set(v1, v4);
            v5 = 1;
            v6 = var3_3;
        } else if (apiVersion.$less(KAFKA_2_1_IV1$.MODULE$)) {
            value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V2());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V2(), (Object)offsetAndMetadata.offset());
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V2(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2(), (Object)offsetAndMetadata.commitTimestamp());
            v5 = 2;
            v6 = value;
        } else {
            value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V3());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V3(), (Object)offsetAndMetadata.offset());
            value.set(this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3(), (Object)offsetAndMetadata.leaderEpoch().orElse(-1));
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V3(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3(), (Object)offsetAndMetadata.commitTimestamp());
            v5 = 3;
            v6 = value;
        }
        var11_9 = v6;
        version = v5;
        byteBuffer = ByteBuffer.allocate(2 + var11_9.sizeOf());
        byteBuffer.putShort((short)var6_10);
        var11_9.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] groupMetadataValue(GroupMetadata groupMetadata, Map<String, byte[]> assignment, ApiVersion apiVersion) {
        List list;
        void var5_5;
        void orNull_ev;
        void var6_6;
        String string;
        Tuple2<Short, Struct> tuple2 = apiVersion.$less(KAFKA_0_10_1_IV0$.MODULE$) ? new Tuple2<Short, Struct>((short)0, new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V0())) : (apiVersion.$less(KAFKA_2_1_IV0$.MODULE$) ? new Tuple2<Short, Struct>((short)1, new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V1())) : (apiVersion.$less(KAFKA_2_3_IV0$.MODULE$) ? new Tuple2<Short, Struct>((short)2, new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V2())) : new Tuple2<Short, Struct>((short)3, new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V3()))));
        short version = BoxesRunTime.unboxToShort(tuple2._1());
        Struct value = tuple2._2();
        String string2 = this.PROTOCOL_TYPE_KEY();
        Option<String> option = groupMetadata.protocolType();
        if (option == null) {
            throw null;
        }
        Option<String> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            String string3;
            String string4 = string3 = "";
            string3 = null;
            string = string4;
        } else {
            string = getOrElse_this.get();
        }
        String string5 = string;
        Object var9_7 = null;
        string = null;
        var6_6.set(string2, (Object)string5);
        var6_6.set(this.GENERATION_KEY(), (Object)groupMetadata.generationId());
        Option<String> option2 = groupMetadata.protocolName();
        $eq$colon$eq $eq$colon$eq = $less$colon$less$.MODULE$.refl();
        if (option2 == null) {
            throw null;
        }
        Option<String> orNull_this = option2;
        String string6 = orNull_this.isEmpty() ? orNull_ev.apply(null) : orNull_this.get();
        String string7 = string6;
        Object var11_11 = null;
        $eq$colon$eq = null;
        string6 = null;
        var6_6.set(this.PROTOCOL_KEY(), (Object)string7);
        var6_6.set(this.LEADER_KEY(), (Object)groupMetadata.leaderOrNull());
        if (var5_5 >= 2) {
            var6_6.set(this.CURRENT_STATE_TIMESTAMP_KEY(), (Object)groupMetadata.currentStateTimestampOrDefault());
        }
        List<MemberMetadata> list2 = groupMetadata.allMemberMetadata();
        if (list2 == null) {
            throw null;
        }
        List<MemberMetadata> map_this = list2;
        if (map_this == Nil$.MODULE$) {
            list = Nil$.MODULE$;
        } else {
            $colon$colon<Nothing$> map_h;
            MemberMetadata memberMetadata = (MemberMetadata)map_this.head();
            $colon$colon<Nothing$> map_t = map_h = new $colon$colon<Nothing$>((Nothing$)((Object)GroupMetadataManager$.$anonfun$groupMetadataValue$2((Struct)var6_6, (short)var5_5, groupMetadata, assignment, memberMetadata)), Nil$.MODULE$);
            for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                memberMetadata = (MemberMetadata)map_rest.head();
                $colon$colon<Nothing$> map_nx = new $colon$colon<Nothing$>((Nothing$)((Object)GroupMetadataManager$.$anonfun$groupMetadataValue$2((Struct)var6_6, (short)var5_5, groupMetadata, assignment, memberMetadata)), Nil$.MODULE$);
                map_t.next_$eq(map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            list = map_h;
        }
        Nil$ nil$ = list;
        Object var14_13 = null;
        Object var15_16 = null;
        Object var16_17 = null;
        Object var17_18 = null;
        Object var18_19 = null;
        list = null;
        Nil$ memberArray = nil$;
        var6_6.set(this.MEMBERS_KEY(), memberArray.toArray(ClassTag$.MODULE$.apply(Struct.class)));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + var6_6.sizeOf());
        byteBuffer.putShort((short)var5_5);
        var6_6.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public BaseKey readMessageKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        Struct key = this.schemaForKey(version).read(buffer);
        if (version <= this.CURRENT_OFFSET_KEY_SCHEMA_VERSION()) {
            String group = (String)key.get(this.OFFSET_KEY_GROUP_FIELD());
            String topic = (String)key.get(this.OFFSET_KEY_TOPIC_FIELD());
            int partition = BoxesRunTime.unboxToInt(key.get(this.OFFSET_KEY_PARTITION_FIELD()));
            return new OffsetKey(version, new GroupTopicPartition(group, new TopicPartition(topic, partition)));
        }
        if (version == this.CURRENT_GROUP_KEY_SCHEMA_VERSION()) {
            String group = (String)key.get(this.GROUP_KEY_GROUP_FIELD());
            return new GroupMetadataKey(version, group);
        }
        throw new IllegalStateException(new StringBuilder(40).append("Unknown group metadata message version: ").append(version).toString());
    }

    public OffsetAndMetadata readOffsetMessageValue(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        short version = buffer.getShort();
        Struct value = this.schemaForOffsetValue(version).read(buffer);
        if (version == 0) {
            long offset = BoxesRunTime.unboxToLong(value.get(this.OFFSET_VALUE_OFFSET_FIELD_V0()));
            String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V0());
            long timestamp = BoxesRunTime.unboxToLong(value.get(this.OFFSET_VALUE_TIMESTAMP_FIELD_V0()));
            return OffsetAndMetadata$.MODULE$.apply(offset, metadata, timestamp);
        }
        if (version == 1) {
            long offset = BoxesRunTime.unboxToLong(value.get(this.OFFSET_VALUE_OFFSET_FIELD_V1()));
            String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V1());
            long commitTimestamp = BoxesRunTime.unboxToLong(value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1()));
            long expireTimestamp = BoxesRunTime.unboxToLong(value.get(this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1()));
            if (expireTimestamp == -1L) {
                return OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp);
            }
            return OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp, expireTimestamp);
        }
        if (version == 2) {
            long offset = BoxesRunTime.unboxToLong(value.get(this.OFFSET_VALUE_OFFSET_FIELD_V2()));
            String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V2());
            long commitTimestamp = BoxesRunTime.unboxToLong(value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2()));
            return OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp);
        }
        if (version == 3) {
            long offset = BoxesRunTime.unboxToLong(value.get(this.OFFSET_VALUE_OFFSET_FIELD_V3()));
            int leaderEpoch = BoxesRunTime.unboxToInt(value.get(this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3()));
            String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V3());
            long commitTimestamp = BoxesRunTime.unboxToLong(value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3()));
            Optional<Integer> leaderEpochOpt = leaderEpoch < 0 ? Optional.empty() : Optional.of(leaderEpoch);
            return new OffsetAndMetadata(offset, leaderEpochOpt, metadata, commitTimestamp, None$.MODULE$);
        }
        throw new IllegalStateException(new StringBuilder(32).append("Unknown offset message version: ").append(version).toString());
    }

    public GroupMetadata readGroupMessageValue(String groupId, ByteBuffer buffer, Time time) {
        if (buffer == null) {
            return null;
        }
        short version = buffer.getShort();
        Struct value = this.schemaForGroupValue(version).read(buffer);
        if (version >= 0 && version <= 3) {
            Object var16_16;
            Long timestamp;
            int generationId = BoxesRunTime.unboxToInt(value.get(this.GENERATION_KEY()));
            String protocolType = (String)value.get(this.PROTOCOL_TYPE_KEY());
            String protocol = (String)value.get(this.PROTOCOL_KEY());
            String leaderId = (String)value.get(this.LEADER_KEY());
            Object[] memberMetadataArray = value.getArray(this.MEMBERS_KEY());
            boolean bl = memberMetadataArray.length == 0;
            GroupState initialState = bl ? Empty$.MODULE$ : Stable$.MODULE$;
            switch (version) {
                default: 
            }
            Option option = version == 2 ? (value.hasField(this.CURRENT_STATE_TIMESTAMP_KEY()) ? (BoxesRunTime.equalsNumObject(timestamp = value.getLong(this.CURRENT_STATE_TIMESTAMP_KEY()), -1) ? None$.MODULE$ : new Some<Long>(BoxesRunTime.unboxToLong(timestamp))) : None$.MODULE$) : None$.MODULE$;
            None$ currentStateTimestamp = option;
            int n = memberMetadataArray.length;
            MemberMetadata[] map$extension_ys = new MemberMetadata[n];
            if (n > 0) {
                for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                    MemberMetadata array_update_value;
                    Object object = memberMetadataArray[map$extension_i];
                    map$extension_ys[map$extension_i] = array_update_value = GroupMetadataManager$.$anonfun$readGroupMessageValue$1(version, groupId, protocolType, protocol, object);
                    Object var20_19 = null;
                }
            }
            void v1 = var16_16;
            var16_16 = null;
            void members = v1;
            return GroupMetadata$.MODULE$.loadGroup(groupId, initialState, generationId, protocolType, protocol, leaderId, currentStateTimestamp, Predef$.MODULE$.wrapRefArray((T[])members), time);
        }
        throw new IllegalStateException(new StringBuilder(40).append("Unknown group metadata message version: ").append(version).toString());
    }

    public Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        Tuple2<Option<String>, Option<String>> tuple2;
        if (!record.hasKey()) {
            throw new KafkaException("Failed to decode message using offset topic decoder (message had a missing key)");
        }
        BaseKey baseKey = this.readMessageKey(record.key());
        if (baseKey instanceof OffsetKey) {
            OffsetKey offsetKey = (OffsetKey)baseKey;
            tuple2 = this.parseOffsets(offsetKey, record.value());
        } else if (baseKey instanceof GroupMetadataKey) {
            GroupMetadataKey groupMetadataKey = (GroupMetadataKey)baseKey;
            tuple2 = this.parseGroupMetadata(groupMetadataKey, record.value());
        } else {
            throw new KafkaException("Failed to decode message using offset topic decoder (message had an invalid key)");
        }
        return tuple2;
    }

    private Tuple2<Option<String>, Option<String>> parseOffsets(OffsetKey offsetKey, ByteBuffer payload) {
        String groupId = offsetKey.key().group();
        TopicPartition topicPartition = offsetKey.key().topicPartition();
        String keyString = new StringBuilder(32).append("offset_commit::group=").append(groupId).append(",partition=").append(topicPartition).toString();
        OffsetAndMetadata offset = this.readOffsetMessageValue(payload);
        String valueString = offset == null ? "<DELETE>" : (offset.metadata().isEmpty() ? new StringBuilder(7).append("offset=").append(offset.offset()).toString() : new StringBuilder(17).append("offset=").append(offset.offset()).append(",metadata=").append(offset.metadata()).toString());
        return new Tuple2<Option<String>, Option<String>>(new Some<String>(keyString), new Some<String>(valueString));
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Option<String>, Option<String>> parseGroupMetadata(GroupMetadataKey groupMetadataKey, ByteBuffer payload) {
        String string;
        String groupId = groupMetadataKey.key();
        String keyString = new StringBuilder(22).append("group_metadata::group=").append(groupId).toString();
        GroupMetadata group = this.readGroupMessageValue(groupId, payload, Time.SYSTEM);
        if (group == null) {
            string = "<DELETE>";
        } else {
            String string2;
            void $minus$greater$extension_y;
            Integer n;
            void $minus$greater$extension_y2;
            void orNull_ev;
            String string3;
            void mkString_end;
            void mkString_sep;
            void mkString_start;
            String string4;
            List list;
            String string5;
            Option<String> option = group.protocolType();
            if (option == null) {
                throw null;
            }
            Option<String> getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                String string6;
                String string7 = string6 = "";
                string6 = null;
                string5 = string7;
            } else {
                string5 = getOrElse_this.get();
            }
            String string8 = string5;
            Object var9_6 = null;
            string5 = null;
            String protocolType = string8;
            List<MemberMetadata> list2 = group.allMemberMetadata();
            if (list2 == null) {
                throw null;
            }
            List<MemberMetadata> map_this = list2;
            if (map_this == Nil$.MODULE$) {
                list = Nil$.MODULE$;
            } else {
                $colon$colon<Nothing$> map_h;
                MemberMetadata memberMetadata = (MemberMetadata)map_this.head();
                $colon$colon<Nothing$> map_t = map_h = new $colon$colon<Nothing$>((Nothing$)((Object)GroupMetadataManager$.$anonfun$parseGroupMetadata$2(protocolType, memberMetadata)), Nil$.MODULE$);
                for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    memberMetadata = (MemberMetadata)map_rest.head();
                    $colon$colon<Nothing$> map_nx = new $colon$colon<Nothing$>((Nothing$)((Object)GroupMetadataManager$.$anonfun$parseGroupMetadata$2(protocolType, memberMetadata)), Nil$.MODULE$);
                    map_t.next_$eq(map_nx);
                    map_t = map_nx;
                }
                Statics.releaseFence();
                list = map_h;
            }
            Nil$ nil$ = list;
            Object var25_10 = null;
            Object var26_13 = null;
            Object var27_14 = null;
            Object var28_15 = null;
            Object var29_16 = null;
            list = null;
            String string9 = "}";
            String string10 = ",";
            String string11 = "{";
            Nil$ mkString_this = nil$;
            String string12 = string4 = IterableOnceOps.mkString$(mkString_this, (String)mkString_start, (String)mkString_sep, (String)mkString_end);
            Object var20_20 = null;
            string11 = null;
            string10 = null;
            string9 = null;
            string4 = null;
            String assignment = string12;
            Tuple2[] tuple2Array = new Tuple2[4];
            String string13 = string3 = "protocolType";
            string3 = null;
            String $minus$greater$extension_$this = string13;
            Object var11_24 = null;
            tuple2Array[0] = new Tuple2<String, String>($minus$greater$extension_$this, protocolType);
            Option<String> option2 = group.protocolName();
            $eq$colon$eq $eq$colon$eq = $less$colon$less$.MODULE$.refl();
            if (option2 == null) {
                throw null;
            }
            Option<String> orNull_this = option2;
            String string14 = orNull_this.isEmpty() ? orNull_ev.apply(null) : orNull_this.get();
            String string15 = string14;
            Object var12_26 = null;
            $eq$colon$eq = null;
            string14 = null;
            String string16 = string15;
            String $minus$greater$extension_$this2 = "protocol";
            Object var15_29 = null;
            string16 = null;
            tuple2Array[1] = new Tuple2<String, void>($minus$greater$extension_$this2, $minus$greater$extension_y2);
            Integer n2 = n = Integer.valueOf(group.generationId());
            n = null;
            Integer n3 = n2;
            String $minus$greater$extension_$this3 = "generationId";
            Object var17_32 = null;
            n3 = null;
            tuple2Array[2] = new Tuple2<String, void>($minus$greater$extension_$this3, $minus$greater$extension_y);
            String string17 = string2 = "assignment";
            string2 = null;
            String $minus$greater$extension_$this4 = string17;
            Object var19_34 = null;
            tuple2Array[3] = new Tuple2<String, String>($minus$greater$extension_$this4, assignment);
            string = Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array))).asJava());
        }
        String valueString = string;
        return new Tuple2<Option<String>, Option<String>>(new Some<String>(keyString), new Some<String>(valueString));
    }

    private String hex(byte[] bytes) {
        boolean bl = bytes.length == 0;
        if (bl) {
            return "";
        }
        return StringOps$.MODULE$.format$extension("%X", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{package$.MODULE$.BigInt().apply(1, bytes)}));
    }

    public static final /* synthetic */ long $anonfun$offsetCommitValue$1() {
        return -1L;
    }

    public static final /* synthetic */ String $anonfun$groupMetadataValue$1() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Struct $anonfun$groupMetadataValue$2(Struct value$1, short version$1, GroupMetadata groupMetadata$1, Map assignment$1, MemberMetadata memberMetadata) {
        void orNull_ev;
        Struct memberStruct = value$1.instance(MODULE$.MEMBERS_KEY());
        memberStruct.set(MODULE$.MEMBER_ID_KEY(), (Object)memberMetadata.memberId());
        memberStruct.set(MODULE$.CLIENT_ID_KEY(), (Object)memberMetadata.clientId());
        memberStruct.set(MODULE$.CLIENT_HOST_KEY(), (Object)memberMetadata.clientHost());
        memberStruct.set(MODULE$.SESSION_TIMEOUT_KEY(), (Object)memberMetadata.sessionTimeoutMs());
        if (version$1 > 0) {
            memberStruct.set(MODULE$.REBALANCE_TIMEOUT_KEY(), (Object)memberMetadata.rebalanceTimeoutMs());
        }
        if (version$1 >= 3) {
            void orNull_ev2;
            Option<String> option = memberMetadata.groupInstanceId();
            $eq$colon$eq $eq$colon$eq = $less$colon$less$.MODULE$.refl();
            if (option == null) {
                throw null;
            }
            Option<String> orNull_this = option;
            String string = orNull_this.isEmpty() ? orNull_ev2.apply(null) : orNull_this.get();
            String string2 = string;
            Object var9_7 = null;
            $eq$colon$eq = null;
            string = null;
            memberStruct.set(MODULE$.GROUP_INSTANCE_ID_KEY(), (Object)string2);
        }
        Option<String> option = groupMetadata$1.protocolName();
        $eq$colon$eq $eq$colon$eq = $less$colon$less$.MODULE$.refl();
        if (option == null) {
            throw null;
        }
        Option<String> orNull_this = option;
        String string = orNull_this.isEmpty() ? orNull_ev.apply(null) : orNull_this.get();
        String string3 = string;
        Object var12_10 = null;
        $eq$colon$eq = null;
        string = null;
        String protocol = string3;
        if (protocol == null) {
            throw new IllegalStateException("Attempted to write non-empty group metadata with no defined protocol");
        }
        byte[] metadata = memberMetadata.metadata(protocol);
        memberStruct.set(MODULE$.SUBSCRIPTION_KEY(), (Object)ByteBuffer.wrap(metadata));
        byte[] memberAssignment = (byte[])assignment$1.apply(memberMetadata.memberId());
        Predef$.MODULE$.assert(memberAssignment != null);
        memberStruct.set(MODULE$.ASSIGNMENT_KEY(), (Object)ByteBuffer.wrap(memberAssignment));
        return memberStruct;
    }

    public static final /* synthetic */ MemberMetadata $anonfun$readGroupMessageValue$1(short version$2, String groupId$6, String protocolType$1, String protocol$1, Object memberMetadataObj) {
        Struct memberMetadata = (Struct)memberMetadataObj;
        String memberId = (String)memberMetadata.get(MODULE$.MEMBER_ID_KEY());
        Option groupInstanceId = version$2 >= 3 ? new Some<String>((String)memberMetadata.get(MODULE$.GROUP_INSTANCE_ID_KEY())) : None$.MODULE$;
        String clientId = (String)memberMetadata.get(MODULE$.CLIENT_ID_KEY());
        String clientHost = (String)memberMetadata.get(MODULE$.CLIENT_HOST_KEY());
        int sessionTimeout = BoxesRunTime.unboxToInt(memberMetadata.get(MODULE$.SESSION_TIMEOUT_KEY()));
        int rebalanceTimeout = version$2 == 0 ? sessionTimeout : BoxesRunTime.unboxToInt(memberMetadata.get(MODULE$.REBALANCE_TIMEOUT_KEY()));
        byte[] subscription = Utils.toArray((ByteBuffer)memberMetadata.get(MODULE$.SUBSCRIPTION_KEY()));
        MemberMetadata member = new MemberMetadata(memberId, groupId$6, groupInstanceId, clientId, clientHost, rebalanceTimeout, sessionTimeout, protocolType$1, new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<String, byte[]>(protocol$1, subscription)), Nil$.MODULE$));
        member.assignment_$eq(Utils.toArray((ByteBuffer)memberMetadata.get(MODULE$.ASSIGNMENT_KEY())));
        return member;
    }

    public static final /* synthetic */ String $anonfun$parseGroupMetadata$1() {
        return "";
    }

    public static final /* synthetic */ byte[] $anonfun$parseGroupMetadata$3(ByteBuffer x$1) {
        return Utils.toArray(x$1);
    }

    public static final /* synthetic */ String $anonfun$parseGroupMetadata$5() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$parseGroupMetadata$2(String protocolType$2, MemberMetadata member) {
        String string = protocolType$2;
        String string2 = "consumer";
        if (string != null && string.equals(string2)) {
            Object object;
            ConsumerPartitionAssignor.Assignment partitionAssignment = ConsumerProtocol.deserializeAssignment(ByteBuffer.wrap(member.assignment()));
            Option<ByteBuffer> option = Option$.MODULE$.apply(partitionAssignment.userData());
            if (option == null) {
                throw null;
            }
            Option<ByteBuffer> map_this = option;
            Option option2 = map_this.isEmpty() ? None$.MODULE$ : new Some<byte[]>(Utils.toArray(map_this.get()));
            None$ none$ = option2;
            Object var5_4 = null;
            option2 = null;
            None$ map_this2 = none$;
            Option option3 = map_this2.isEmpty() ? None$.MODULE$ : new Some<String>(GroupMetadataManager$.MODULE$.hex((byte[])((Option)map_this2).get()));
            None$ none$2 = option3;
            Object var7_6 = null;
            option3 = null;
            None$ getOrElse_this = none$2;
            if (getOrElse_this.isEmpty()) {
                String string3;
                String string4 = string3 = "";
                string3 = null;
                object = string4;
            } else {
                object = ((Option)getOrElse_this).get();
            }
            Object a = object;
            Object var9_8 = null;
            object = null;
            String userData = (String)a;
            if (userData.isEmpty()) {
                return new StringBuilder(1).append(member.memberId()).append("=").append(partitionAssignment.partitions()).toString();
            }
            return new StringBuilder(2).append(member.memberId()).append("=").append(partitionAssignment.partitions()).append(":").append(userData).toString();
        }
        return new StringBuilder(1).append(member.memberId()).append("=").append(MODULE$.hex(member.assignment())).toString();
    }

    private GroupMetadataManager$() {
    }
}

