/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.controller;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import rpl.shaded.kafka.controller.ControllerEvent;
import rpl.shaded.kafka.controller.ControllerEventProcessor;
import rpl.shaded.scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005}3AAD\b\u0001)!A1\u0004\u0001BC\u0002\u0013\u0005A\u0004\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001e\u0011!\u0011\u0003A!b\u0001\n\u0003\u0019\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\t\u000b!\u0002A\u0011A\u0015\t\u000f5\u0002!\u0019!C\u0001]!1\u0011\b\u0001Q\u0001\n=BqA\u000f\u0001C\u0002\u0013\u00051\b\u0003\u0004C\u0001\u0001\u0006I\u0001\u0010\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\u0006\u001b\u0002!\tA\u0014\u0005\u0006!\u0002!\t!\u0015\u0005\u0006%\u0002!\te\u0015\u0002\f#V,W/\u001a3Fm\u0016tGO\u0003\u0002\u0011#\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003I\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001+A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\fQ!\u001a<f]R,\u0012!\b\t\u0003=}i\u0011aD\u0005\u0003A=\u0011qbQ8oiJ|G\u000e\\3s\u000bZ,g\u000e^\u0001\u0007KZ,g\u000e\u001e\u0011\u0002\u001b\u0015t\u0017/^3vKRKW.Z't+\u0005!\u0003C\u0001\f&\u0013\t1sC\u0001\u0003M_:<\u0017AD3ocV,W/\u001a+j[\u0016l5\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007)ZC\u0006\u0005\u0002\u001f\u0001!)1$\u0002a\u0001;!)!%\u0002a\u0001I\u0005\t\u0002O]8dKN\u001c\u0018N\\4Ti\u0006\u0014H/\u001a3\u0016\u0003=\u0002\"\u0001M\u001c\u000e\u0003ER!AM\u001a\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00025k\u0005!Q\u000f^5m\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u0019\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\u0006\u0011\u0002O]8dKN\u001c\u0018N\\4Ti\u0006\u0014H/\u001a3!\u0003\u0015\u0019\b/\u001a8u+\u0005a\u0004CA\u001fA\u001b\u0005q$BA 2\u0003\u0019\tGo\\7jG&\u0011\u0011I\u0010\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\rM\u0004XM\u001c;!\u0003\u001d\u0001(o\\2fgN$\"!\u0012%\u0011\u0005Y1\u0015BA$\u0018\u0005\u0011)f.\u001b;\t\u000b%S\u0001\u0019\u0001&\u0002\u0013A\u0014xnY3tg>\u0014\bC\u0001\u0010L\u0013\tauB\u0001\rD_:$(o\u001c7mKJ,e/\u001a8u!J|7-Z:t_J\fq\u0001\u001d:fK6\u0004H\u000f\u0006\u0002F\u001f\")\u0011j\u0003a\u0001\u0015\u0006y\u0011m^1jiB\u0013xnY3tg&tw\rF\u0001F\u0003!!xn\u0015;sS:<G#\u0001+\u0011\u0005UcfB\u0001,[!\t9v#D\u0001Y\u0015\tI6#\u0001\u0004=e>|GOP\u0005\u00037^\ta\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111l\u0006")
public class QueuedEvent {
    private final ControllerEvent event;
    private final long enqueueTimeMs;
    private final CountDownLatch processingStarted;
    private final AtomicBoolean spent;

    public ControllerEvent event() {
        return this.event;
    }

    public long enqueueTimeMs() {
        return this.enqueueTimeMs;
    }

    public CountDownLatch processingStarted() {
        return this.processingStarted;
    }

    public AtomicBoolean spent() {
        return this.spent;
    }

    public void process(ControllerEventProcessor processor) {
        if (this.spent().getAndSet(true)) {
            return;
        }
        this.processingStarted().countDown();
        processor.process(this.event());
    }

    public void preempt(ControllerEventProcessor processor) {
        if (this.spent().getAndSet(true)) {
            return;
        }
        processor.preempt(this.event());
    }

    public void awaitProcessing() {
        this.processingStarted().await();
    }

    public String toString() {
        return new StringBuilder(35).append("QueuedEvent(event=").append(this.event()).append(", enqueueTimeMs=").append(this.enqueueTimeMs()).append(")").toString();
    }

    public QueuedEvent(ControllerEvent event, long enqueueTimeMs) {
        this.event = event;
        this.enqueueTimeMs = enqueueTimeMs;
        this.processingStarted = new CountDownLatch(1);
        this.spent = new AtomicBoolean(false);
    }
}

