/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.admin;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.admin.DelegationTokenCommand;
import rpl.shaded.kafka.utils.CommandLineUtils$;
import rpl.shaded.kafka.utils.Exit$;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.org.apache.kafka.clients.admin.Admin;
import rpl.shaded.org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import rpl.shaded.org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import rpl.shaded.org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import rpl.shaded.org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import rpl.shaded.org.apache.kafka.clients.admin.RenewDelegationTokenOptions;
import rpl.shaded.org.apache.kafka.common.security.auth.KafkaPrincipal;
import rpl.shaded.org.apache.kafka.common.security.token.delegation.DelegationToken;
import rpl.shaded.org.apache.kafka.common.security.token.delegation.TokenInformation;
import rpl.shaded.org.apache.kafka.common.utils.SecurityUtils;
import rpl.shaded.org.apache.kafka.common.utils.Utils;
import rpl.shaded.scala.$eq$colon$eq;
import rpl.shaded.scala.$less$colon$less;
import rpl.shaded.scala.$less$colon$less$;
import rpl.shaded.scala.Console$;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.IterableOps;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.SeqOps;
import rpl.shaded.scala.collection.StringOps$;
import rpl.shaded.scala.collection.immutable.$colon$colon;
import rpl.shaded.scala.collection.immutable.Nil$;
import rpl.shaded.scala.collection.immutable.Seq;
import rpl.shaded.scala.collection.immutable.Seq$;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.Nothing$;
import rpl.shaded.scala.runtime.ScalaRunTime$;

public final class DelegationTokenCommand$
implements Logging {
    public static final DelegationTokenCommand$ MODULE$ = new DelegationTokenCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        DelegationTokenCommand.DelegationTokenCommandOptions opts = new DelegationTokenCommand.DelegationTokenCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to create, renew, expire, or describe delegation tokens.");
        if (Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new OptionSpecBuilder[]{opts.createOpt(), opts.renewOpt(), opts.expiryOpt(), opts.describeOpt()})).count(arg_0 -> DelegationTokenCommand$.$anonfun$main$1$adapted(opts.options(), arg_0)) != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --create, --renew, --expire or --describe");
        }
        opts.checkArgs();
        Admin adminClient = this.createAdminClient(opts);
        int exitCode = 0;
        try {
            try {
                if (opts.options().has((OptionSpec)opts.createOpt())) {
                    this.createToken(adminClient, opts);
                } else if (opts.options().has((OptionSpec)opts.renewOpt())) {
                    this.renewToken(adminClient, opts);
                } else if (opts.options().has((OptionSpec)opts.expiryOpt())) {
                    this.expireToken(adminClient, opts);
                } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    this.describeToken(adminClient, opts);
                }
            }
            catch (Throwable e) {
                String println_x = new StringBuilder(49).append("Error while executing delegation token command : ").append(e.getMessage()).toString();
                Console$.MODULE$.println(println_x);
                Object var6_6 = null;
                if (this.logger().underlying().isErrorEnabled()) {
                    String string;
                    String string2 = string = Utils.stackTrace(e);
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var7_8 = null;
                    this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                exitCode = 1;
            }
        }
        catch (Throwable throwable) {
            adminClient.close();
            throw Exit$.MODULE$.exit(exitCode, None$.MODULE$);
        }
        adminClient.close();
        throw Exit$.MODULE$.exit(exitCode, None$.MODULE$);
    }

    public DelegationToken createToken(Admin adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        List<KafkaPrincipal> list;
        Option<List<KafkaPrincipal>> option = this.getPrincipals(opts, opts.renewPrincipalsOpt());
        if (option == null) {
            throw null;
        }
        Option<List<KafkaPrincipal>> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            LinkedList<KafkaPrincipal> linkedList;
            LinkedList<KafkaPrincipal> linkedList2 = linkedList = new LinkedList<KafkaPrincipal>();
            linkedList = null;
            list = linkedList2;
        } else {
            list = getOrElse_this.get();
        }
        List<KafkaPrincipal> list2 = list;
        Object var6_3 = null;
        list = null;
        List<KafkaPrincipal> renewerPrincipals = list2;
        long l = BoxesRunTime.unboxToLong(opts.options().valueOf(opts.maxLifeTimeOpt()));
        String println_x = new StringBuilder(71).append("Calling create token operation with renewers :").append(renewerPrincipals).append(" , max-life-time-period :").append(l).toString();
        Console$.MODULE$.println(println_x);
        Object var10_8 = null;
        CreateDelegationTokenOptions createDelegationTokenOptions = new CreateDelegationTokenOptions().maxlifeTimeMs(l).renewers(renewerPrincipals);
        DelegationToken token = adminClient.createDelegationToken(createDelegationTokenOptions).delegationToken().get();
        String println_x2 = StringOps$.MODULE$.format$extension("Created delegation token with tokenId : %s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{token.tokenInfo().tokenId()}));
        Console$.MODULE$.println(println_x2);
        Object var11_11 = null;
        this.printToken(new $colon$colon<Nothing$>((Nothing$)((Object)token), Nil$.MODULE$));
        return token;
    }

    public void printToken(rpl.shaded.scala.collection.immutable.List<DelegationToken> tokens) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        String print_x = StringOps$.MODULE$.format$extension("\n%-15s %-30s %-15s %-25s %-15s %-15s %-15s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{"TOKENID", "HMAC", "OWNER", "RENEWERS", "ISSUEDATE", "EXPIRYDATE", "MAXDATE"}));
        Console$.MODULE$.print(print_x);
        Object var4_3 = null;
        if (tokens == null) {
            throw null;
        }
        rpl.shaded.scala.collection.immutable.List foreach_these = tokens;
        while (!foreach_these.isEmpty()) {
            DelegationToken delegationToken = (DelegationToken)foreach_these.head();
            DelegationTokenCommand$.$anonfun$printToken$1(dateFormat, delegationToken);
            foreach_these = (rpl.shaded.scala.collection.immutable.List)foreach_these.tail();
        }
    }

    private Option<List<KafkaPrincipal>> getPrincipals(DelegationTokenCommand.DelegationTokenCommandOptions opts, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        if (opts.options().has(principalOptionSpec)) {
            return new Some<List<KafkaPrincipal>>(JavaConverters$.MODULE$.seqAsJavaListConverter(((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(principalOptionSpec)).asScala()).map((Function1<String, KafkaPrincipal> & Serializable)s -> SecurityUtils.parseKafkaPrincipal(s.trim()))).toList()).asJava());
        }
        return None$.MODULE$;
    }

    public long renewToken(Admin adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        String hmac = (String)opts.options().valueOf(opts.hmacOpt());
        long l = BoxesRunTime.unboxToLong(opts.options().valueOf(opts.renewTimePeriodOpt()));
        String println_x = new StringBuilder(63).append("Calling renew token operation with hmac :").append(hmac).append(" , renew-time-period :").append(l).toString();
        Console$.MODULE$.println(println_x);
        Object var8_5 = null;
        Long expiryTimeStamp = adminClient.renewDelegationToken(Base64.getDecoder().decode(hmac), new RenewDelegationTokenOptions().renewTimePeriodMs(l)).expiryTimestamp().get();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        String println_x2 = StringOps$.MODULE$.format$extension("Completed renew operation. New expiry date : %s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{dateFormat.format(expiryTimeStamp)}));
        Console$.MODULE$.println(println_x2);
        Object var9_8 = null;
        return BoxesRunTime.unboxToLong(expiryTimeStamp);
    }

    public long expireToken(Admin adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        String hmac = (String)opts.options().valueOf(opts.hmacOpt());
        long l = BoxesRunTime.unboxToLong(opts.options().valueOf(opts.expiryTimePeriodOpt()));
        String println_x = new StringBuilder(66).append("Calling expire token operation with hmac :").append(hmac).append(" , expire-time-period : ").append(l).toString();
        Console$.MODULE$.println(println_x);
        Object var8_5 = null;
        Long expiryTimeStamp = adminClient.expireDelegationToken(Base64.getDecoder().decode(hmac), new ExpireDelegationTokenOptions().expiryTimePeriodMs(l)).expiryTimestamp().get();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        String println_x2 = StringOps$.MODULE$.format$extension("Completed expire operation. New expiry date : %s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{dateFormat.format(expiryTimeStamp)}));
        Console$.MODULE$.println(println_x2);
        Object var9_8 = null;
        return BoxesRunTime.unboxToLong(expiryTimeStamp);
    }

    public rpl.shaded.scala.collection.immutable.List<DelegationToken> describeToken(Admin adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        Option<List<KafkaPrincipal>> ownerPrincipals = this.getPrincipals(opts, opts.ownerPrincipalsOpt());
        if (ownerPrincipals.isEmpty()) {
            String println_x = "Calling describe token operation for current user.";
            Console$.MODULE$.println(println_x);
            Object var8_4 = null;
        } else {
            String println_x = new StringBuilder(45).append("Calling describe token operation for owners :").append(ownerPrincipals.get()).toString();
            Console$.MODULE$.println(println_x);
            Object var9_5 = null;
        }
        $eq$colon$eq orNull_ev = $less$colon$less$.MODULE$.refl();
        List<KafkaPrincipal> list = ownerPrincipals.isEmpty() ? (($less$colon$less)orNull_ev).apply(null) : ownerPrincipals.get();
        List<KafkaPrincipal> list2 = list;
        Object var6_6 = null;
        list = null;
        DescribeDelegationTokenResult describeResult = adminClient.describeDelegationToken(new DescribeDelegationTokenOptions().owners(list2));
        rpl.shaded.scala.collection.immutable.List<DelegationToken> tokens = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(describeResult.delegationTokens().get()).asScala()).toList();
        Object[] objectArray = new Object[1];
        if (tokens == null) {
            throw null;
        }
        objectArray[0] = SeqOps.size$(tokens);
        String println_x = StringOps$.MODULE$.format$extension("Total number of tokens : %s", ScalaRunTime$.MODULE$.genericWrapArray(objectArray));
        Console$.MODULE$.println(println_x);
        Object var10_10 = null;
        this.printToken(tokens);
        return tokens;
    }

    private Admin createAdminClient(DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        Properties props = Utils.loadProps((String)opts.options().valueOf(opts.commandConfigOpt()), null);
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return Admin.create(props);
    }

    public static final /* synthetic */ String $anonfun$main$2(Throwable e$1) {
        return Utils.stackTrace(e$1);
    }

    public static final /* synthetic */ LinkedList $anonfun$createToken$1() {
        return new LinkedList();
    }

    public static final /* synthetic */ void $anonfun$printToken$1(SimpleDateFormat dateFormat$1, DelegationToken token) {
        TokenInformation tokenInfo = token.tokenInfo();
        String print_x = StringOps$.MODULE$.format$extension("\n%-15s %-30s %-15s %-25s %-15s %-15s %-15s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{tokenInfo.tokenId(), token.hmacAsBase64String(), tokenInfo.owner(), tokenInfo.renewersAsString(), dateFormat$1.format(tokenInfo.issueTimestamp()), dateFormat$1.format(tokenInfo.expiryTimestamp()), dateFormat$1.format(tokenInfo.maxTimestamp())}));
        Console$.MODULE$.print(print_x);
        Object var3_3 = null;
        Console$.MODULE$.println();
    }

    private DelegationTokenCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean(eta$0$1$1.has(x$1));
    }

    public static final /* synthetic */ Object $anonfun$printToken$1$adapted(SimpleDateFormat dateFormat$1, DelegationToken token) {
        DelegationTokenCommand$.$anonfun$printToken$1(dateFormat$1, token);
        return BoxedUnit.UNIT;
    }
}

