/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.admin;

import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.admin.AclCommand;
import rpl.shaded.kafka.security.authorizer.AclAuthorizer;
import rpl.shaded.kafka.security.authorizer.AclEntry$;
import rpl.shaded.kafka.utils.CommandLineUtils$;
import rpl.shaded.kafka.utils.Exit$;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.org.apache.kafka.common.acl.AccessControlEntry;
import rpl.shaded.org.apache.kafka.common.acl.AclOperation;
import rpl.shaded.org.apache.kafka.common.acl.AclPermissionType;
import rpl.shaded.org.apache.kafka.common.resource.PatternType;
import rpl.shaded.org.apache.kafka.common.resource.ResourcePattern;
import rpl.shaded.org.apache.kafka.common.resource.ResourcePatternFilter;
import rpl.shaded.org.apache.kafka.common.resource.ResourceType;
import rpl.shaded.org.apache.kafka.common.security.auth.KafkaPrincipal;
import rpl.shaded.org.apache.kafka.common.utils.SecurityUtils;
import rpl.shaded.org.apache.kafka.common.utils.Utils;
import rpl.shaded.scala.$less$colon$less$;
import rpl.shaded.scala.Console$;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Predef$;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.IterableFactory;
import rpl.shaded.scala.collection.IterableOnce;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.IterableOps;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.MapFactory;
import rpl.shaded.scala.collection.MapOps;
import rpl.shaded.scala.collection.immutable.ArraySeq;
import rpl.shaded.scala.collection.immutable.Map;
import rpl.shaded.scala.collection.immutable.Map$;
import rpl.shaded.scala.collection.immutable.Map$EmptyMap$;
import rpl.shaded.scala.collection.immutable.Seq;
import rpl.shaded.scala.collection.immutable.Set;
import rpl.shaded.scala.collection.immutable.Set$;
import rpl.shaded.scala.collection.immutable.Set$EmptySet$;
import rpl.shaded.scala.collection.immutable.SetOps;
import rpl.shaded.scala.collection.mutable.HashSet;
import rpl.shaded.scala.io.StdIn;
import rpl.shaded.scala.io.StdIn$;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.Nothing$;
import rpl.shaded.scala.runtime.ObjectRef;
import rpl.shaded.scala.runtime.ScalaRunTime$;
import rpl.shaded.scala.util.Properties$;
import rpl.shaded.scala.util.PropertiesTrait;

public final class AclCommand$
implements Logging {
    public static final AclCommand$ MODULE$ = new AclCommand$();
    private static final ResourcePatternFilter ClusterResourceFilter = new ResourcePatternFilter(ResourceType.CLUSTER, "rpl.shaded.kafka-cluster", PatternType.LITERAL);
    private static final String kafka$admin$AclCommand$$Newline = PropertiesTrait.lineSeparator$(Properties$.MODULE$);
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public ResourcePatternFilter ClusterResourceFilter() {
        return ClusterResourceFilter;
    }

    public String kafka$admin$AclCommand$$Newline() {
        return kafka$admin$AclCommand$$Newline;
    }

    public void main(String[] args) {
        AclCommand.AclCommandService aclCommandService;
        AclCommand.AclCommandOptions opts = new AclCommand.AclCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to manage acls on kafka.");
        opts.checkArgs();
        if (opts.options().has(opts.bootstrapServerOpt())) {
            aclCommandService = new AclCommand.AdminClientService(opts);
        } else {
            String authorizerClassName = opts.options().has(opts.authorizerOpt()) ? (String)opts.options().valueOf(opts.authorizerOpt()) : AclAuthorizer.class.getName();
            aclCommandService = new AclCommand.AuthorizerService(authorizerClassName, opts);
        }
        AclCommand.AdminClientService aclCommandService2 = aclCommandService;
        try {
            if (opts.options().has((OptionSpec)opts.addOpt())) {
                ((AclCommand.AclCommandService)aclCommandService2).addAcls();
            } else if (opts.options().has((OptionSpec)opts.removeOpt())) {
                ((AclCommand.AclCommandService)aclCommandService2).removeAcls();
            } else if (opts.options().has((OptionSpec)opts.listOpt())) {
                ((AclCommand.AclCommandService)aclCommandService2).listAcls();
            }
        }
        catch (Throwable e) {
            String println_x = new StringBuilder(35).append("Error while executing ACL command: ").append(e.getMessage()).toString();
            Console$.MODULE$.println(println_x);
            Object var6_6 = null;
            String println_x2 = Utils.stackTrace(e);
            Console$.MODULE$.println(println_x2);
            Object var7_7 = null;
            throw Exit$.MODULE$.exit(1, None$.MODULE$);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<ResourcePattern, Set<AccessControlEntry>> kafka$admin$AclCommand$$getResourceToAcls(AclCommand.AclCommandOptions opts) {
        void var3_3;
        PatternType patternType = (PatternType)((Object)opts.options().valueOf(opts.resourcePatternType()));
        if (!patternType.isSpecific()) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), new StringBuilder(70).append("A '--resource-pattern-type' value of '").append((Object)patternType).append("' is not valid when adding acls.").toString());
        }
        Map resourceToAcl = (Map)this.kafka$admin$AclCommand$$getResourceFilterToAcls(opts).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2<ResourcePattern, Set> tuple2;
            ResourcePattern resourcePattern;
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            ResourcePatternFilter filter = (ResourcePatternFilter)x0$1._1();
            Set acls = (Set)x0$1._2();
            ResourcePattern resourcePattern2 = resourcePattern = new ResourcePattern(filter.resourceType(), filter.name(), filter.patternType());
            resourcePattern = null;
            ResourcePattern $minus$greater$extension_$this = resourcePattern2;
            Tuple2<ResourcePattern, Set> tuple22 = tuple2 = new Tuple2<ResourcePattern, Set>($minus$greater$extension_$this, acls);
            Object var4_4 = null;
            tuple2 = null;
            Tuple2<ResourcePattern, Set> tuple23 = tuple22;
            return tuple23;
        });
        if (resourceToAcl.values().exists((Function1<Set, Object> & Serializable)x$24 -> BoxesRunTime.boxToBoolean(x$24.isEmpty()))) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "You must specify one of: --allow-principal, --deny-principal when trying to add ACLs.");
        }
        return var3_3;
    }

    public Map<ResourcePatternFilter, Set<AccessControlEntry>> kafka$admin$AclCommand$$getResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        ObjectRef<Map$EmptyMap$> objectRef;
        Map$EmptyMap$ map$EmptyMap$;
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        Map$EmptyMap$ map$EmptyMap$2 = map$EmptyMap$ = Map$EmptyMap$.MODULE$;
        map$EmptyMap$ = null;
        Map$EmptyMap$ create_e = map$EmptyMap$2;
        ObjectRef<Map$EmptyMap$> objectRef2 = objectRef = new ObjectRef<Map$EmptyMap$>(create_e);
        Object var3_3 = null;
        objectRef = null;
        ObjectRef<Map$EmptyMap$> resourceToAcls = objectRef2;
        if (!opts.options().has((OptionSpec)opts.producerOpt()) && !opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = (Map)((Map)resourceToAcls.elem).$plus$plus(this.getCliResourceFilterToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.producerOpt())) {
            resourceToAcls.elem = (Map)((Map)resourceToAcls.elem).$plus$plus(this.getProducerResourceFilterToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = (Map)((Map)resourceToAcls.elem).$plus$plus(this.getConsumerResourceFilterToAcls(opts).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                Tuple2 tuple2;
                void $plus$plus_that;
                Object c;
                IterableOnce iterableOnce;
                Set v;
                ResourcePatternFilter k;
                if (x0$1 != null) {
                    k = (ResourcePatternFilter)x0$1._1();
                    v = (Set)x0$1._2();
                    iterableOnce = (IterableOnce)((Map)resourceToAcls$5.elem).getOrElse(k, (Function0<Set> & Serializable)() -> {
                        Predef$.MODULE$.Set();
                        return Set$EmptySet$.MODULE$;
                    });
                    if (v == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError((Object)null);
                }
                Object c2 = c = v.concat($plus$plus_that);
                iterableOnce = null;
                c = null;
                Object $minus$greater$extension_y = c2;
                Tuple2 tuple22 = tuple2 = new Tuple2(k, $minus$greater$extension_y);
                Object var7_6 = null;
                tuple2 = null;
                Tuple2 tuple23 = tuple22;
                return tuple23;
            }));
        }
        this.validateOperation(opts, (Map)resourceToAcls.elem);
        return (Map)resourceToAcls.elem;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ResourcePatternFilter, Set<AccessControlEntry>> getProducerResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        IterableOnce<Tuple2<Object, Nothing$>> iterableOnce;
        void apply_elems;
        void apply_elems2;
        Set<ResourcePatternFilter> filters = this.kafka$admin$AclCommand$$getResourceFilter(opts, true);
        Set topics = (Set)filters.filter((Function1<ResourcePatternFilter, Object> & Serializable)x$25 -> BoxesRunTime.boxToBoolean(AclCommand$.$anonfun$getProducerResourceFilterToAcls$1(x$25)));
        Set transactionalIds = (Set)filters.filter((Function1<ResourcePatternFilter, Object> & Serializable)x$26 -> BoxesRunTime.boxToBoolean(AclCommand$.$anonfun$getProducerResourceFilterToAcls$2(x$26)));
        boolean enableIdempotence = opts.options().has((OptionSpec)opts.idempotentOpt());
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq<AclOperation> arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE, AclOperation.CREATE});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set<AccessControlEntry> topicAcls = this.getAcl(opts, (Set)IterableFactory.apply$(set$, (Seq)apply_elems2));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq<AclOperation> arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Set<AccessControlEntry> transactionalIdAcls = this.getAcl(opts, (Set)IterableFactory.apply$(set$2, (Seq)apply_elems));
        MapOps mapOps = (MapOps)((IterableOnceOps)topics.map((Function1<ResourcePatternFilter, Tuple2> & Serializable)x$27 -> new Tuple2<ResourcePatternFilter, Set>((ResourcePatternFilter)x$27, topicAcls))).toMap($less$colon$less$.MODULE$.refl()).$plus$plus(((IterableOnceOps)transactionalIds.map((Function1<ResourcePatternFilter, Tuple2> & Serializable)x$28 -> new Tuple2<ResourcePatternFilter, Set>((ResourcePatternFilter)x$28, transactionalIdAcls))).toMap($less$colon$less$.MODULE$.refl()));
        if (enableIdempotence) {
            void apply_elems3;
            void $minus$greater$extension_y;
            void apply_elems4;
            Map$ map$ = Predef$.MODULE$.Map();
            Tuple2[] tuple2Array = new Tuple2[1];
            Set$ set$3 = Predef$.MODULE$.Set();
            ArraySeq<AclOperation> arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(new AclOperation[]{AclOperation.IDEMPOTENT_WRITE});
            if (set$3 == null) {
                throw null;
            }
            arraySeq3 = null;
            Set<AccessControlEntry> set = this.getAcl(opts, (Set)IterableFactory.apply$(set$3, (Seq)apply_elems4));
            ResourcePatternFilter $minus$greater$extension_$this = this.ClusterResourceFilter();
            Object var8_12 = null;
            set = null;
            tuple2Array[0] = new Tuple2<ResourcePatternFilter, void>($minus$greater$extension_$this, $minus$greater$extension_y);
            ArraySeq<Tuple2> arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array);
            if (map$ == null) {
                throw null;
            }
            arraySeq4 = null;
            iterableOnce = (IterableOnce)MapFactory.apply$(map$, (Seq)apply_elems3);
        } else {
            if (Predef$.MODULE$.Map() == null) {
                throw null;
            }
            iterableOnce = Map$EmptyMap$.MODULE$;
        }
        return (Map)mapOps.$plus$plus(iterableOnce);
    }

    /*
     * WARNING - void declaration
     */
    private Map<ResourcePatternFilter, Set<AccessControlEntry>> getConsumerResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        void apply_elems;
        Set<ResourcePatternFilter> filters = this.kafka$admin$AclCommand$$getResourceFilter(opts, true);
        Set topics = (Set)filters.filter((Function1<ResourcePatternFilter, Object> & Serializable)x$29 -> BoxesRunTime.boxToBoolean(AclCommand$.$anonfun$getConsumerResourceFilterToAcls$1(x$29)));
        Set groups = (Set)filters.filter((Function1<ResourcePatternFilter, Object> & Serializable)x$30 -> BoxesRunTime.boxToBoolean(AclCommand$.$anonfun$getConsumerResourceFilterToAcls$2(x$30)));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq<AclOperation> arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set<AccessControlEntry> acls = this.getAcl(opts, (Set)IterableFactory.apply$(set$, (Seq)apply_elems));
        return (Map)((IterableOnceOps)topics.map((Function1<ResourcePatternFilter, Tuple2> & Serializable)x$31 -> new Tuple2<ResourcePatternFilter, Set>((ResourcePatternFilter)x$31, acls))).toMap($less$colon$less$.MODULE$.refl()).$plus$plus(((IterableOnceOps)groups.map((Function1<ResourcePatternFilter, Tuple2> & Serializable)x$32 -> {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq<AclOperation> arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(new AclOperation[]{AclOperation.READ});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Set<AccessControlEntry> $minus$greater$extension_y = MODULE$.getAcl(opts, (Set)IterableFactory.apply$(set$, (Seq)apply_elems));
            return new Tuple2<ResourcePatternFilter, Set<AccessControlEntry>>((ResourcePatternFilter)x$32, $minus$greater$extension_y);
        })).toMap($less$colon$less$.MODULE$.refl()));
    }

    private Map<ResourcePatternFilter, Set<AccessControlEntry>> getCliResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        Set<AccessControlEntry> acls = this.getAcl(opts);
        return ((IterableOnceOps)this.kafka$admin$AclCommand$$getResourceFilter(opts, true).map((Function1<ResourcePatternFilter, Tuple2> & Serializable)x$33 -> new Tuple2<ResourcePatternFilter, Set>((ResourcePatternFilter)x$33, acls))).toMap($less$colon$less$.MODULE$.refl());
    }

    private Set<AccessControlEntry> getAcl(AclCommand.AclCommandOptions opts, Set<AclOperation> operations) {
        Set<KafkaPrincipal> allowedPrincipals = this.kafka$admin$AclCommand$$getPrincipals(opts, opts.allowPrincipalsOpt());
        Set<KafkaPrincipal> deniedPrincipals = this.kafka$admin$AclCommand$$getPrincipals(opts, opts.denyPrincipalsOpt());
        Set<String> allowedHosts = this.getHosts(opts, opts.allowHostsOpt(), opts.allowPrincipalsOpt());
        Set<String> deniedHosts = this.getHosts(opts, opts.denyHostsOpt(), opts.denyPrincipalsOpt());
        HashSet acls = new HashSet();
        if (allowedHosts.nonEmpty() && allowedPrincipals.nonEmpty()) {
            Set<AccessControlEntry> $plus$plus$eq_xs = this.getAcls(allowedPrincipals, AclPermissionType.ALLOW, operations, allowedHosts);
            acls.addAll((IterableOnce)$plus$plus$eq_xs);
            Object var8_8 = null;
        }
        if (deniedHosts.nonEmpty() && deniedPrincipals.nonEmpty()) {
            Set<AccessControlEntry> $plus$plus$eq_xs = this.getAcls(deniedPrincipals, AclPermissionType.DENY, operations, deniedHosts);
            acls.addAll((IterableOnce)$plus$plus$eq_xs);
            Object var9_9 = null;
        }
        return IterableOnceOps.toSet$(acls);
    }

    private Set<AccessControlEntry> getAcl(AclCommand.AclCommandOptions opts) {
        Set<AclOperation> operations = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.operationsOpt())).asScala()).map((Function1<String, AclOperation> & Serializable)operation -> SecurityUtils.operation(operation.trim()))).toSet();
        return this.getAcl(opts, operations);
    }

    public Set<AccessControlEntry> getAcls(Set<KafkaPrincipal> principals, AclPermissionType permissionType, Set<AclOperation> operations, Set<String> hosts) {
        return (Set)principals.flatMap((Function1<KafkaPrincipal, Set> & Serializable)principal -> (Set)operations.flatMap((Function1<AclOperation, Set> & Serializable)operation -> (Set)hosts.map((Function1<String, AccessControlEntry> & Serializable)host -> new AccessControlEntry(principal.toString(), (String)host, (AclOperation)((Object)((Object)operation)), permissionType))));
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> getHosts(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> hostOptionSpec, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        if (opts.options().has(hostOptionSpec)) {
            return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(hostOptionSpec)).asScala()).map((Function1<String, String> & Serializable)x$34 -> x$34.trim())).toSet();
        }
        if (opts.options().has(principalOptionSpec)) {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq<String> arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(new String[]{AclEntry$.MODULE$.WildcardHost()});
            if (set$ == null) {
                throw null;
            }
            return (Set)IterableFactory.apply$(set$, (Seq)apply_elems);
        }
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        return Set$EmptySet$.MODULE$;
    }

    public Set<KafkaPrincipal> kafka$admin$AclCommand$$getPrincipals(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        if (opts.options().has(principalOptionSpec)) {
            return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(principalOptionSpec)).asScala()).map((Function1<String, KafkaPrincipal> & Serializable)s -> SecurityUtils.parseKafkaPrincipal(s.trim()))).toSet();
        }
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        return Set$EmptySet$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Set<ResourcePatternFilter> kafka$admin$AclCommand$$getResourceFilter(AclCommand.AclCommandOptions opts, boolean dieIfNoResourceFound) {
        ObjectRef<Set$EmptySet$> objectRef;
        Set$EmptySet$ set$EmptySet$;
        PatternType patternType = (PatternType)((Object)opts.options().valueOf(opts.resourcePatternType()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$EmptySet$ set$EmptySet$2 = set$EmptySet$ = Set$EmptySet$.MODULE$;
        set$EmptySet$ = null;
        Set$EmptySet$ create_e = set$EmptySet$2;
        ObjectRef<Set$EmptySet$> objectRef2 = objectRef = new ObjectRef<Set$EmptySet$>(create_e);
        Object var6_5 = null;
        objectRef = null;
        ObjectRef<Set$EmptySet$> resourceFilters = objectRef2;
        if (opts.options().has(opts.topicOpt())) {
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.topicOpt())).asScala()).foreach((Function1<String, Object> & Serializable)topic -> {
                AclCommand$.$anonfun$getResourceFilter$1(resourceFilters, patternType, topic);
                return BoxedUnit.UNIT;
            });
        }
        PatternType patternType2 = patternType;
        PatternType patternType3 = PatternType.LITERAL;
        if (!(patternType2 != null ? !((Object)((Object)patternType2)).equals((Object)patternType3) : patternType3 != null)) {
            if (opts.options().has((OptionSpec)opts.clusterOpt()) || opts.options().has((OptionSpec)opts.idempotentOpt())) {
                void $plus_elem;
                Set set = (Set)resourceFilters.elem;
                ResourcePatternFilter resourcePatternFilter = this.ClusterResourceFilter();
                if (set == null) {
                    throw null;
                }
                resourcePatternFilter = null;
                resourceFilters.elem = (Set)set.incl($plus_elem);
            }
        }
        if (opts.options().has(opts.groupOpt())) {
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.groupOpt())).asScala()).foreach((Function1<String, Object> & Serializable)group -> {
                AclCommand$.$anonfun$getResourceFilter$2(resourceFilters, patternType, group);
                return BoxedUnit.UNIT;
            });
        }
        if (opts.options().has(opts.transactionalIdOpt())) {
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.transactionalIdOpt())).asScala()).foreach((Function1<String, Object> & Serializable)transactionalId -> {
                AclCommand$.$anonfun$getResourceFilter$3(resourceFilters, patternType, transactionalId);
                return BoxedUnit.UNIT;
            });
        }
        if (opts.options().has(opts.delegationTokenOpt())) {
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.delegationTokenOpt())).asScala()).foreach((Function1<String, Object> & Serializable)token -> {
                AclCommand$.$anonfun$getResourceFilter$4(resourceFilters, patternType, token);
                return BoxedUnit.UNIT;
            });
        }
        if (((Set)resourceFilters.elem).isEmpty() && dieIfNoResourceFound) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "You must provide at least one resource: --topic <topic> or --cluster or --group <group> or --delegation-token <Delegation Token ID>");
        }
        return (Set)resourceFilters.elem;
    }

    private boolean getResourceFilter$default$2() {
        return true;
    }

    public boolean kafka$admin$AclCommand$$confirmAction(AclCommand.AclCommandOptions opts, String msg) {
        if (opts.options().has((OptionSpec)opts.forceOpt())) {
            return true;
        }
        Console$.MODULE$.println(msg);
        return StdIn.readLine$(StdIn$.MODULE$).equalsIgnoreCase("y");
    }

    private void validateOperation(AclCommand.AclCommandOptions opts, Map<ResourcePatternFilter, Set<AccessControlEntry>> resourceToAcls) {
        resourceToAcls.withFilter((Function1<Tuple2<ResourcePatternFilter, Set<AccessControlEntry>>, Object>)(Function1<Tuple2, Object> & Serializable)check$ifrefutable$9 -> BoxesRunTime.boxToBoolean(bl = check$ifrefutable$9 != null)).foreach((Function1<Tuple2, Object> & Serializable)x$36 -> {
            AclCommand$.$anonfun$validateOperation$2(opts, x$36);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getProducerResourceFilterToAcls$1(ResourcePatternFilter x$25) {
        ResourceType resourceType = x$25.resourceType();
        ResourceType resourceType2 = ResourceType.TOPIC;
        return !(resourceType != null ? !((Object)((Object)resourceType)).equals((Object)resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getProducerResourceFilterToAcls$2(ResourcePatternFilter x$26) {
        ResourceType resourceType = x$26.resourceType();
        ResourceType resourceType2 = ResourceType.TRANSACTIONAL_ID;
        return !(resourceType != null ? !((Object)((Object)resourceType)).equals((Object)resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsumerResourceFilterToAcls$1(ResourcePatternFilter x$29) {
        ResourceType resourceType = x$29.resourceType();
        ResourceType resourceType2 = ResourceType.TOPIC;
        return !(resourceType != null ? !((Object)((Object)resourceType)).equals((Object)resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsumerResourceFilterToAcls$2(ResourcePatternFilter x$30) {
        ResourceType resourceType = x$30.resourceType();
        ResourceType resourceType2 = ResourceType.GROUP;
        return !(resourceType != null ? !((Object)((Object)resourceType)).equals((Object)resourceType2) : resourceType2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$getResourceFilter$1(ObjectRef resourceFilters$1, PatternType patternType$1, String topic) {
        void $plus_elem;
        Set set = (Set)resourceFilters$1.elem;
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(ResourceType.TOPIC, topic.trim(), patternType$1);
        if (set == null) {
            throw null;
        }
        resourceFilters$1.elem = (Set)set.incl($plus_elem);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$getResourceFilter$2(ObjectRef resourceFilters$1, PatternType patternType$1, String group) {
        void $plus_elem;
        Set set = (Set)resourceFilters$1.elem;
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(ResourceType.GROUP, group.trim(), patternType$1);
        if (set == null) {
            throw null;
        }
        resourceFilters$1.elem = (Set)set.incl($plus_elem);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$getResourceFilter$3(ObjectRef resourceFilters$1, PatternType patternType$1, String transactionalId) {
        void $plus_elem;
        Set set = (Set)resourceFilters$1.elem;
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(ResourceType.TRANSACTIONAL_ID, transactionalId, patternType$1);
        if (set == null) {
            throw null;
        }
        resourceFilters$1.elem = (Set)set.incl($plus_elem);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$getResourceFilter$4(ObjectRef resourceFilters$1, PatternType patternType$1, String token) {
        void $plus_elem;
        Set set = (Set)resourceFilters$1.elem;
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(ResourceType.DELEGATION_TOKEN, token.trim(), patternType$1);
        if (set == null) {
            throw null;
        }
        resourceFilters$1.elem = (Set)set.incl($plus_elem);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$validateOperation$2(AclCommand.AclCommandOptions opts$2, Tuple2 x$36) {
        if (x$36 != null) {
            void $plus_elem;
            ResourcePatternFilter resource = (ResourcePatternFilter)x$36._1();
            Set acls = (Set)x$36._2();
            Set<AclOperation> set = AclEntry$.MODULE$.supportedOperations(resource.resourceType());
            AclOperation aclOperation = AclOperation.ALL;
            if (set == null) {
                throw null;
            }
            aclOperation = null;
            Set validOps = (Set)set.incl((AclOperation)$plus_elem);
            SetOps setOps = (SetOps)acls.map((Function1<AccessControlEntry, AclOperation> & Serializable)x$35 -> x$35.operation());
            if (setOps == null) {
                throw null;
            }
            if (setOps.removedAll(validOps).nonEmpty()) {
                void mkString_sep;
                String string = ",";
                if (validOps == null) {
                    throw null;
                }
                string = null;
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts$2.parser(), new StringBuilder(39).append("ResourceType ").append((Object)resource.resourceType()).append(" only supports operations ").append(validOps.mkString("", (String)mkString_sep, "")).toString());
            }
        } else {
            throw new MatchError((Object)null);
        }
    }

    private AclCommand$() {
    }
}

